/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.CreateModelMetaResponse;
import org.opensearch.client.opensearch.ml.FunctionName;
import org.opensearch.client.opensearch.ml.ModelConfig;
import org.opensearch.client.opensearch.ml.ModelFormat;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateModelMetaRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateModelMetaRequest> {
    @Nullable
    private final String description;
    @Nullable
    private final FunctionName functionName;
    @Nonnull
    private final ModelConfig modelConfig;
    @Nonnull
    private final String modelContentHashValue;
    @Nonnull
    private final ModelFormat modelFormat;
    @Nullable
    private final String modelGroupId;
    @Nonnull
    private final String name;
    private final long totalChunks;
    @Nullable
    private final String url;
    @Nonnull
    private final String version;
    public static final JsonpDeserializer<CreateModelMetaRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateModelMetaRequest::setupCreateModelMetaRequestDeserializer);
    public static final Endpoint<CreateModelMetaRequest, CreateModelMetaResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateModelMetaRequest, CreateModelMetaResponse>(request -> "POST", request -> "/_plugins/_ml/models/meta", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateModelMetaResponse._DESERIALIZER);

    private CreateModelMetaRequest(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.functionName = builder.functionName;
        this.modelConfig = ApiTypeHelper.requireNonNull(builder.modelConfig, this, "modelConfig");
        this.modelContentHashValue = ApiTypeHelper.requireNonNull(builder.modelContentHashValue, this, "modelContentHashValue");
        this.modelFormat = ApiTypeHelper.requireNonNull(builder.modelFormat, this, "modelFormat");
        this.modelGroupId = builder.modelGroupId;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.totalChunks = ApiTypeHelper.requireNonNull(builder.totalChunks, this, "totalChunks");
        this.url = builder.url;
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static CreateModelMetaRequest of(Function<Builder, ObjectBuilder<CreateModelMetaRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final FunctionName functionName() {
        return this.functionName;
    }

    @Nonnull
    public final ModelConfig modelConfig() {
        return this.modelConfig;
    }

    @Nonnull
    public final String modelContentHashValue() {
        return this.modelContentHashValue;
    }

    @Nonnull
    public final ModelFormat modelFormat() {
        return this.modelFormat;
    }

    @Nullable
    public final String modelGroupId() {
        return this.modelGroupId;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    public final long totalChunks() {
        return this.totalChunks;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Nonnull
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.functionName != null) {
            generator.writeKey("function_name");
            this.functionName.serialize(generator, mapper);
        }
        generator.writeKey("model_config");
        this.modelConfig.serialize(generator, mapper);
        generator.writeKey("model_content_hash_value");
        generator.write(this.modelContentHashValue);
        generator.writeKey("model_format");
        this.modelFormat.serialize(generator, mapper);
        if (this.modelGroupId != null) {
            generator.writeKey("model_group_id");
            generator.write(this.modelGroupId);
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("total_chunks");
        generator.write(this.totalChunks);
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
        generator.writeKey("version");
        generator.write(this.version);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateModelMetaRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::functionName, FunctionName._DESERIALIZER, "function_name");
        op.add(Builder::modelConfig, ModelConfig._DESERIALIZER, "model_config");
        op.add(Builder::modelContentHashValue, JsonpDeserializer.stringDeserializer(), "model_content_hash_value");
        op.add(Builder::modelFormat, ModelFormat._DESERIALIZER, "model_format");
        op.add(Builder::modelGroupId, JsonpDeserializer.stringDeserializer(), "model_group_id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::totalChunks, JsonpDeserializer.longDeserializer(), "total_chunks");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.functionName);
        result = 31 * result + this.modelConfig.hashCode();
        result = 31 * result + this.modelContentHashValue.hashCode();
        result = 31 * result + this.modelFormat.hashCode();
        result = 31 * result + Objects.hashCode(this.modelGroupId);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Long.hashCode(this.totalChunks);
        result = 31 * result + Objects.hashCode(this.url);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateModelMetaRequest other = (CreateModelMetaRequest)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.functionName, other.functionName) && this.modelConfig.equals(other.modelConfig) && this.modelContentHashValue.equals(other.modelContentHashValue) && this.modelFormat.equals(other.modelFormat) && Objects.equals(this.modelGroupId, other.modelGroupId) && this.name.equals(other.name) && this.totalChunks == other.totalChunks && Objects.equals(this.url, other.url) && this.version.equals(other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateModelMetaRequest> {
        @Nullable
        private String description;
        @Nullable
        private FunctionName functionName;
        private ModelConfig modelConfig;
        private String modelContentHashValue;
        private ModelFormat modelFormat;
        @Nullable
        private String modelGroupId;
        private String name;
        private Long totalChunks;
        @Nullable
        private String url;
        private String version;

        public Builder() {
        }

        private Builder(CreateModelMetaRequest o) {
            super(o);
            this.description = o.description;
            this.functionName = o.functionName;
            this.modelConfig = o.modelConfig;
            this.modelContentHashValue = o.modelContentHashValue;
            this.modelFormat = o.modelFormat;
            this.modelGroupId = o.modelGroupId;
            this.name = o.name;
            this.totalChunks = o.totalChunks;
            this.url = o.url;
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.description = o.description;
            this.functionName = o.functionName;
            this.modelConfig = o.modelConfig;
            this.modelContentHashValue = o.modelContentHashValue;
            this.modelFormat = o.modelFormat;
            this.modelGroupId = o.modelGroupId;
            this.name = o.name;
            this.totalChunks = o.totalChunks;
            this.url = o.url;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder functionName(@Nullable FunctionName value) {
            this.functionName = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(ModelConfig value) {
            this.modelConfig = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(Function<ModelConfig.Builder, ObjectBuilder<ModelConfig>> fn) {
            return this.modelConfig(fn.apply(new ModelConfig.Builder()).build());
        }

        @Nonnull
        public final Builder modelContentHashValue(String value) {
            this.modelContentHashValue = value;
            return this;
        }

        @Nonnull
        public final Builder modelFormat(ModelFormat value) {
            this.modelFormat = value;
            return this;
        }

        @Nonnull
        public final Builder modelGroupId(@Nullable String value) {
            this.modelGroupId = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder totalChunks(long value) {
            this.totalChunks = value;
            return this;
        }

        @Nonnull
        public final Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        @Nonnull
        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateModelMetaRequest build() {
            this._checkSingleUse();
            return new CreateModelMetaRequest(this);
        }
    }
}

