/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class Metadata
implements PlainJsonSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Number primaryTerm;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final Long version;

    protected Metadata(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.primaryTerm = ((AbstractBuilder)builder).primaryTerm;
        this.seqNo = ((AbstractBuilder)builder).seqNo;
        this.version = ((AbstractBuilder)builder).version;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Number primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.doubleValue());
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMetadataDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.numberDeserializer(), "_primary_term");
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.primaryTerm);
        result = 31 * result + Objects.hashCode(this.seqNo);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata other = (Metadata)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.version, other.version);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String id;
        @Nullable
        private Number primaryTerm;
        @Nullable
        private Long seqNo;
        @Nullable
        private Long version;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(Metadata o) {
            this.id = o.id;
            this.primaryTerm = o.primaryTerm;
            this.seqNo = o.seqNo;
            this.version = o.version;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.id = o.id;
            this.primaryTerm = o.primaryTerm;
            this.seqNo = o.seqNo;
            this.version = o.version;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT primaryTerm(@Nullable Number value) {
            this.primaryTerm = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }
    }
}

