/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.CharFilter;
import org.opensearch.client.opensearch._types.analysis.Normalizer;
import org.opensearch.client.opensearch._types.analysis.TokenFilter;
import org.opensearch.client.opensearch._types.analysis.Tokenizer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSettingsAnalysis
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSettingsAnalysis> {
    @Nonnull
    private final Map<String, Analyzer> analyzer;
    @Nonnull
    private final Map<String, CharFilter> charFilter;
    @Nonnull
    private final Map<String, TokenFilter> filter;
    @Nonnull
    private final Map<String, Normalizer> normalizer;
    @Nonnull
    private final Map<String, Tokenizer> tokenizer;
    public static final JsonpDeserializer<IndexSettingsAnalysis> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsAnalysis::setupIndexSettingsAnalysisDeserializer);

    private IndexSettingsAnalysis(Builder builder) {
        this.analyzer = ApiTypeHelper.unmodifiable(builder.analyzer);
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.normalizer = ApiTypeHelper.unmodifiable(builder.normalizer);
        this.tokenizer = ApiTypeHelper.unmodifiable(builder.tokenizer);
    }

    public static IndexSettingsAnalysis of(Function<Builder, ObjectBuilder<IndexSettingsAnalysis>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Analyzer> analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final Map<String, CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nonnull
    public final Map<String, TokenFilter> filter() {
        return this.filter;
    }

    @Nonnull
    public final Map<String, Normalizer> normalizer() {
        return this.normalizer;
    }

    @Nonnull
    public final Map<String, Tokenizer> tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.analyzer)) {
            generator.writeKey("analyzer");
            generator.writeStartObject();
            for (Map.Entry<String, Analyzer> entry : this.analyzer.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartObject();
            for (Map.Entry<String, TaggedUnion<Analyzer.Kind, AnalyzerVariant>> entry : this.charFilter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CharFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartObject();
            for (Map.Entry<String, TaggedUnion<Analyzer.Kind, AnalyzerVariant>> entry : this.filter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((TokenFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.normalizer)) {
            generator.writeKey("normalizer");
            generator.writeStartObject();
            for (Map.Entry<String, TaggedUnion<Analyzer.Kind, AnalyzerVariant>> entry : this.normalizer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Normalizer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tokenizer)) {
            generator.writeKey("tokenizer");
            generator.writeStartObject();
            for (Map.Entry<String, TaggedUnion<Analyzer.Kind, AnalyzerVariant>> entry : this.tokenizer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Tokenizer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSettingsAnalysisDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringMapDeserializer(Analyzer._DESERIALIZER), "analyzer");
        op.add(Builder::charFilter, JsonpDeserializer.stringMapDeserializer(CharFilter._DESERIALIZER), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.stringMapDeserializer(TokenFilter._DESERIALIZER), "filter");
        op.add(Builder::normalizer, JsonpDeserializer.stringMapDeserializer(Normalizer._DESERIALIZER), "normalizer");
        op.add(Builder::tokenizer, JsonpDeserializer.stringMapDeserializer(Tokenizer._DESERIALIZER), "tokenizer");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.charFilter);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.normalizer);
        result = 31 * result + Objects.hashCode(this.tokenizer);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsAnalysis other = (IndexSettingsAnalysis)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.charFilter, other.charFilter) && Objects.equals(this.filter, other.filter) && Objects.equals(this.normalizer, other.normalizer) && Objects.equals(this.tokenizer, other.tokenizer);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSettingsAnalysis> {
        @Nullable
        private Map<String, Analyzer> analyzer;
        @Nullable
        private Map<String, CharFilter> charFilter;
        @Nullable
        private Map<String, TokenFilter> filter;
        @Nullable
        private Map<String, Normalizer> normalizer;
        @Nullable
        private Map<String, Tokenizer> tokenizer;

        public Builder() {
        }

        private Builder(IndexSettingsAnalysis o) {
            this.analyzer = Builder._mapCopy(o.analyzer);
            this.charFilter = Builder._mapCopy(o.charFilter);
            this.filter = Builder._mapCopy(o.filter);
            this.normalizer = Builder._mapCopy(o.normalizer);
            this.tokenizer = Builder._mapCopy(o.tokenizer);
        }

        private Builder(Builder o) {
            this.analyzer = Builder._mapCopy(o.analyzer);
            this.charFilter = Builder._mapCopy(o.charFilter);
            this.filter = Builder._mapCopy(o.filter);
            this.normalizer = Builder._mapCopy(o.normalizer);
            this.tokenizer = Builder._mapCopy(o.tokenizer);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzer(Map<String, Analyzer> map) {
            this.analyzer = Builder._mapPutAll(this.analyzer, map);
            return this;
        }

        @Nonnull
        public final Builder analyzer(String key, Analyzer value) {
            this.analyzer = Builder._mapPut(this.analyzer, key, value);
            return this;
        }

        @Nonnull
        public final Builder analyzer(String key, Function<Analyzer.Builder, ObjectBuilder<Analyzer>> fn) {
            return this.analyzer(key, fn.apply(new Analyzer.Builder()).build());
        }

        @Nonnull
        public final Builder charFilter(Map<String, CharFilter> map) {
            this.charFilter = Builder._mapPutAll(this.charFilter, map);
            return this;
        }

        @Nonnull
        public final Builder charFilter(String key, CharFilter value) {
            this.charFilter = Builder._mapPut(this.charFilter, key, value);
            return this;
        }

        @Nonnull
        public final Builder charFilter(String key, Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(key, fn.apply(new CharFilter.Builder()).build());
        }

        @Nonnull
        public final Builder filter(Map<String, TokenFilter> map) {
            this.filter = Builder._mapPutAll(this.filter, map);
            return this;
        }

        @Nonnull
        public final Builder filter(String key, TokenFilter value) {
            this.filter = Builder._mapPut(this.filter, key, value);
            return this;
        }

        @Nonnull
        public final Builder filter(String key, Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(key, fn.apply(new TokenFilter.Builder()).build());
        }

        @Nonnull
        public final Builder normalizer(Map<String, Normalizer> map) {
            this.normalizer = Builder._mapPutAll(this.normalizer, map);
            return this;
        }

        @Nonnull
        public final Builder normalizer(String key, Normalizer value) {
            this.normalizer = Builder._mapPut(this.normalizer, key, value);
            return this;
        }

        @Nonnull
        public final Builder normalizer(String key, Function<Normalizer.Builder, ObjectBuilder<Normalizer>> fn) {
            return this.normalizer(key, fn.apply(new Normalizer.Builder()).build());
        }

        @Nonnull
        public final Builder tokenizer(Map<String, Tokenizer> map) {
            this.tokenizer = Builder._mapPutAll(this.tokenizer, map);
            return this;
        }

        @Nonnull
        public final Builder tokenizer(String key, Tokenizer value) {
            this.tokenizer = Builder._mapPut(this.tokenizer, key, value);
            return this;
        }

        @Nonnull
        public final Builder tokenizer(String key, Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(key, fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        @Nonnull
        public IndexSettingsAnalysis build() {
            this._checkSingleUse();
            return new IndexSettingsAnalysis(this);
        }
    }
}

