/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.RenderSearchTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RenderSearchTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String file;
    @Nullable
    private final String id;
    private final Map<String, JsonData> params;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<RenderSearchTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RenderSearchTemplateRequest::setupRenderSearchTemplateRequestDeserializer);
    public static final Endpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_render");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_render");
            buf.append("/template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RenderSearchTemplateResponse._DESERIALIZER);

    private RenderSearchTemplateRequest(Builder builder) {
        this.file = builder.file;
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
    }

    public static RenderSearchTemplateRequest of(Function<Builder, ObjectBuilder<RenderSearchTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String file() {
        return this.file;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.file != null) {
            generator.writeKey("file");
            generator.write(this.file);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    public Builder toBuilder() {
        return new Builder().file(this.file).id(this.id).params(this.params).source(this.source);
    }

    protected static void setupRenderSearchTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::file, JsonpDeserializer.stringDeserializer(), "file");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RenderSearchTemplateRequest> {
        @Nullable
        private String file;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String source;

        public final Builder file(@Nullable String value) {
            this.file = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        public RenderSearchTemplateRequest build() {
            this._checkSingleUse();
            return new RenderSearchTemplateRequest(this);
        }
    }
}

