/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat.health;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class HealthRecord
implements JsonpSerializable {
    @Nullable
    private final String epoch;
    @Nullable
    private final String timestamp;
    @Nullable
    private final String cluster;
    @Nullable
    private final String status;
    @Nullable
    private final String nodeTotal;
    @Nullable
    private final String nodeData;
    @Nullable
    private final String shards;
    @Nullable
    private final String pri;
    @Nullable
    private final String relo;
    @Nullable
    private final String init;
    @Nullable
    private final String unassign;
    @Nullable
    private final String pendingTasks;
    @Nullable
    private final String maxTaskWaitTime;
    @Nullable
    private final String activeShardsPercent;
    public static final JsonpDeserializer<HealthRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HealthRecord::setupHealthRecordDeserializer);

    private HealthRecord(Builder builder) {
        this.epoch = builder.epoch;
        this.timestamp = builder.timestamp;
        this.cluster = builder.cluster;
        this.status = builder.status;
        this.nodeTotal = builder.nodeTotal;
        this.nodeData = builder.nodeData;
        this.shards = builder.shards;
        this.pri = builder.pri;
        this.relo = builder.relo;
        this.init = builder.init;
        this.unassign = builder.unassign;
        this.pendingTasks = builder.pendingTasks;
        this.maxTaskWaitTime = builder.maxTaskWaitTime;
        this.activeShardsPercent = builder.activeShardsPercent;
    }

    public static HealthRecord of(Function<Builder, ObjectBuilder<HealthRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String epoch() {
        return this.epoch;
    }

    @Nullable
    public final String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String cluster() {
        return this.cluster;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Nullable
    public final String nodeTotal() {
        return this.nodeTotal;
    }

    @Nullable
    public final String nodeData() {
        return this.nodeData;
    }

    @Nullable
    public final String shards() {
        return this.shards;
    }

    @Nullable
    public final String pri() {
        return this.pri;
    }

    @Nullable
    public final String relo() {
        return this.relo;
    }

    @Nullable
    public final String init() {
        return this.init;
    }

    @Nullable
    public final String unassign() {
        return this.unassign;
    }

    @Nullable
    public final String pendingTasks() {
        return this.pendingTasks;
    }

    @Nullable
    public final String maxTaskWaitTime() {
        return this.maxTaskWaitTime;
    }

    @Nullable
    public final String activeShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.epoch != null) {
            generator.writeKey("epoch");
            generator.write(this.epoch);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
        if (this.cluster != null) {
            generator.writeKey("cluster");
            generator.write(this.cluster);
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
        if (this.nodeTotal != null) {
            generator.writeKey("node.total");
            generator.write(this.nodeTotal);
        }
        if (this.nodeData != null) {
            generator.writeKey("node.data");
            generator.write(this.nodeData);
        }
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.write(this.shards);
        }
        if (this.pri != null) {
            generator.writeKey("pri");
            generator.write(this.pri);
        }
        if (this.relo != null) {
            generator.writeKey("relo");
            generator.write(this.relo);
        }
        if (this.init != null) {
            generator.writeKey("init");
            generator.write(this.init);
        }
        if (this.unassign != null) {
            generator.writeKey("unassign");
            generator.write(this.unassign);
        }
        if (this.pendingTasks != null) {
            generator.writeKey("pending_tasks");
            generator.write(this.pendingTasks);
        }
        if (this.maxTaskWaitTime != null) {
            generator.writeKey("max_task_wait_time");
            generator.write(this.maxTaskWaitTime);
        }
        if (this.activeShardsPercent != null) {
            generator.writeKey("active_shards_percent");
            generator.write(this.activeShardsPercent);
        }
    }

    protected static void setupHealthRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::epoch, JsonpDeserializer.stringDeserializer(), "epoch", "time");
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", "ts", "hms", "hhmmss");
        op.add(Builder::cluster, JsonpDeserializer.stringDeserializer(), "cluster", "cl");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status", "st");
        op.add(Builder::nodeTotal, JsonpDeserializer.stringDeserializer(), "node.total", "nt", "nodeTotal");
        op.add(Builder::nodeData, JsonpDeserializer.stringDeserializer(), "node.data", "nd", "nodeData");
        op.add(Builder::shards, JsonpDeserializer.stringDeserializer(), "shards", "t", "sh", "shards.total", "shardsTotal");
        op.add(Builder::pri, JsonpDeserializer.stringDeserializer(), "pri", "p", "shards.primary", "shardsPrimary");
        op.add(Builder::relo, JsonpDeserializer.stringDeserializer(), "relo", "r", "shards.relocating", "shardsRelocating");
        op.add(Builder::init, JsonpDeserializer.stringDeserializer(), "init", "i", "shards.initializing", "shardsInitializing");
        op.add(Builder::unassign, JsonpDeserializer.stringDeserializer(), "unassign", "u", "shards.unassigned", "shardsUnassigned");
        op.add(Builder::pendingTasks, JsonpDeserializer.stringDeserializer(), "pending_tasks", "pt", "pendingTasks");
        op.add(Builder::maxTaskWaitTime, JsonpDeserializer.stringDeserializer(), "max_task_wait_time", "mtwt", "maxTaskWaitTime");
        op.add(Builder::activeShardsPercent, JsonpDeserializer.stringDeserializer(), "active_shards_percent", "asp", "activeShardsPercent");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HealthRecord> {
        @Nullable
        private String epoch;
        @Nullable
        private String timestamp;
        @Nullable
        private String cluster;
        @Nullable
        private String status;
        @Nullable
        private String nodeTotal;
        @Nullable
        private String nodeData;
        @Nullable
        private String shards;
        @Nullable
        private String pri;
        @Nullable
        private String relo;
        @Nullable
        private String init;
        @Nullable
        private String unassign;
        @Nullable
        private String pendingTasks;
        @Nullable
        private String maxTaskWaitTime;
        @Nullable
        private String activeShardsPercent;

        public final Builder epoch(@Nullable String value) {
            this.epoch = value;
            return this;
        }

        public final Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        public final Builder cluster(@Nullable String value) {
            this.cluster = value;
            return this;
        }

        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        public final Builder nodeTotal(@Nullable String value) {
            this.nodeTotal = value;
            return this;
        }

        public final Builder nodeData(@Nullable String value) {
            this.nodeData = value;
            return this;
        }

        public final Builder shards(@Nullable String value) {
            this.shards = value;
            return this;
        }

        public final Builder pri(@Nullable String value) {
            this.pri = value;
            return this;
        }

        public final Builder relo(@Nullable String value) {
            this.relo = value;
            return this;
        }

        public final Builder init(@Nullable String value) {
            this.init = value;
            return this;
        }

        public final Builder unassign(@Nullable String value) {
            this.unassign = value;
            return this;
        }

        public final Builder pendingTasks(@Nullable String value) {
            this.pendingTasks = value;
            return this;
        }

        public final Builder maxTaskWaitTime(@Nullable String value) {
            this.maxTaskWaitTime = value;
            return this;
        }

        public final Builder activeShardsPercent(@Nullable String value) {
            this.activeShardsPercent = value;
            return this;
        }

        @Override
        public HealthRecord build() {
            this._checkSingleUse();
            return new HealthRecord(this);
        }
    }
}

