/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.SearchIdle;
import org.opensearch.client.opensearch.indices.SearchSlowlog;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndexSettingsSearch
implements JsonpSerializable {
    @Nullable
    private final SearchIdle idle;
    @Nullable
    private final SearchSlowlog slowlog;
    public static final JsonpDeserializer<IndexSettingsSearch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsSearch::setupSettingsSearchDeserializer);

    private IndexSettingsSearch(Builder builder) {
        this.idle = builder.idle;
        this.slowlog = builder.slowlog;
    }

    public static IndexSettingsSearch of(Function<Builder, ObjectBuilder<IndexSettingsSearch>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SearchIdle idle() {
        return this.idle;
    }

    @Nullable
    public final SearchSlowlog slowlog() {
        return this.slowlog;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.idle != null) {
            generator.writeKey("idle");
            this.idle.serialize(generator, mapper);
        }
        if (this.slowlog != null) {
            generator.writeKey("slowlog");
            this.slowlog.serialize(generator, mapper);
        }
    }

    protected static void setupSettingsSearchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::idle, SearchIdle._DESERIALIZER, "idle");
        op.add(Builder::slowlog, SearchSlowlog._DESERIALIZER, "slowlog");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSettingsSearch> {
        @Nullable
        private SearchIdle idle;
        @Nullable
        private SearchSlowlog slowlog;

        public final Builder idle(@Nullable SearchIdle value) {
            this.idle = value;
            return this;
        }

        public final Builder idle(Function<SearchIdle.Builder, ObjectBuilder<SearchIdle>> fn) {
            return this.idle(fn.apply(new SearchIdle.Builder()).build());
        }

        public final Builder slowlog(@Nullable SearchSlowlog value) {
            this.slowlog = value;
            return this;
        }

        public final Builder slowlog(Function<SearchSlowlog.Builder, ObjectBuilder<SearchSlowlog>> fn) {
            return this.slowlog(fn.apply(new SearchSlowlog.Builder()).build());
        }

        @Override
        public IndexSettingsSearch build() {
            this._checkSingleUse();
            return new IndexSettingsSearch(this);
        }
    }
}

