/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.opensearch.core.search.CompletionSuggest;
import org.opensearch.client.opensearch.core.search.PhraseSuggest;
import org.opensearch.client.opensearch.core.search.SuggestVariant;
import org.opensearch.client.opensearch.core.search.TermSuggest;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

public class Suggest<TDocument>
implements TaggedUnion<Kind, SuggestVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final SuggestVariant _value;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final SuggestVariant _get() {
        return this._value;
    }

    public Suggest(SuggestVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._suggestionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Suggest(Builder<TDocument> builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static <TDocument> Suggest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<Suggest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggest<TDocument> completion() {
        return (CompletionSuggest)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggest phrase() {
        return (PhraseSuggest)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggest term() {
        return (TermSuggest)TaggedUnionUtils.get(this, Kind.Term);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
    }

    public static <TDocument> ExternallyTaggedUnion.TypedKeysDeserializer<Suggest<TDocument>> createSuggestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        HashMap deserializers = new HashMap();
        deserializers.put("completion", CompletionSuggest.createCompletionSuggestDeserializer(tDocumentDeserializer));
        deserializers.put("phrase", PhraseSuggest._DESERIALIZER);
        deserializers.put("term", TermSuggest._DESERIALIZER);
        return new ExternallyTaggedUnion.Deserializer<Suggest, SuggestVariant>(deserializers, Suggest::new).typedKeys();
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<Suggest<TDocument>> {
        private Kind _kind;
        private SuggestVariant _value;

        public ObjectBuilder<Suggest<TDocument>> completion(CompletionSuggest<TDocument> v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggest<TDocument>> completion(Function<CompletionSuggest.Builder<TDocument>, ObjectBuilder<CompletionSuggest<TDocument>>> fn) {
            return this.completion(fn.apply(new CompletionSuggest.Builder()).build());
        }

        public ObjectBuilder<Suggest<TDocument>> phrase(PhraseSuggest v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggest<TDocument>> phrase(Function<PhraseSuggest.Builder, ObjectBuilder<PhraseSuggest>> fn) {
            return this.phrase(fn.apply(new PhraseSuggest.Builder()).build());
        }

        public ObjectBuilder<Suggest<TDocument>> term(TermSuggest v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggest<TDocument>> term(Function<TermSuggest.Builder, ObjectBuilder<TermSuggest>> fn) {
            return this.term(fn.apply(new TermSuggest.Builder()).build());
        }

        @Override
        public Suggest<TDocument> build() {
            this._checkSingleUse();
            return new Suggest(this);
        }
    }

    public static enum Kind {
        Completion,
        Phrase,
        Term;

    }
}

