/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Http
implements PlainJsonSerializable {
    private final int currentOpen;
    private final long totalOpened;
    public static final JsonpDeserializer<Http> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Http::setupHttpDeserializer);

    private Http(Builder builder) {
        this.currentOpen = ApiTypeHelper.requireNonNull(builder.currentOpen, this, "currentOpen");
        this.totalOpened = ApiTypeHelper.requireNonNull(builder.totalOpened, this, "totalOpened");
    }

    public static Http of(Function<Builder, ObjectBuilder<Http>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int currentOpen() {
        return this.currentOpen;
    }

    public final long totalOpened() {
        return this.totalOpened;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_open");
        generator.write(this.currentOpen);
        generator.writeKey("total_opened");
        generator.write(this.totalOpened);
    }

    protected static void setupHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentOpen, JsonpDeserializer.integerDeserializer(), "current_open");
        op.add(Builder::totalOpened, JsonpDeserializer.longDeserializer(), "total_opened");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Http> {
        private Integer currentOpen;
        private Long totalOpened;

        public final Builder currentOpen(int value) {
            this.currentOpen = value;
            return this;
        }

        public final Builder totalOpened(long value) {
            this.totalOpened = value;
            return this;
        }

        @Override
        public Http build() {
            this._checkSingleUse();
            return new Http(this);
        }
    }
}

