/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class KnnQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final float[] vector;
    @Nullable
    private final Integer k;
    @Nullable
    private final Float minScore;
    @Nullable
    private final Float maxDistance;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<KnnQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnQuery::setupKnnQueryDeserializer);

    private KnnQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.vector = ApiTypeHelper.requireNonNull(builder.vector, this, "vector");
        this.k = builder.k;
        this.minScore = builder.minScore;
        this.maxDistance = builder.maxDistance;
        this.filter = builder.filter;
    }

    public static KnnQuery of(Function<Builder, ObjectBuilder<KnnQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Knn;
    }

    public final String field() {
        return this.field;
    }

    public final float[] vector() {
        return this.vector;
    }

    @Nullable
    public final Integer k() {
        return this.k;
    }

    @Nullable
    private final Float minScore() {
        return this.minScore;
    }

    @Nullable
    private final Float maxDistance() {
        return this.maxDistance;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("vector");
        generator.writeStartArray();
        for (float value : this.vector) {
            generator.write((double)value);
        }
        generator.writeEnd();
        if (this.k != null) {
            generator.write("k", this.k.intValue());
        }
        if (this.minScore != null) {
            generator.write("min_score", (double)this.minScore.floatValue());
        }
        if (this.maxDistance != null) {
            generator.write("max_distance", (double)this.maxDistance.floatValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).vector(this.vector).k(this.k).minScore(this.minScore).maxDistance(this.maxDistance).filter(this.filter);
    }

    protected static void setupKnnQueryDeserializer(ObjectDeserializer<Builder> op) {
        KnnQuery.setupQueryBaseDeserializer(op);
        op.add((b, v) -> {
            float[] vector = new float[v.size()];
            int i = 0;
            for (Float value : v) {
                vector[i++] = value.floatValue();
            }
            b.vector(vector);
        }, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "vector");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::maxDistance, JsonpDeserializer.floatDeserializer(), "max_distance");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KnnQuery> {
        @Nullable
        private String field;
        @Nullable
        private float[] vector;
        @Nullable
        private Integer k;
        @Nullable
        private Float minScore;
        @Nullable
        private Float maxDistance;
        @Nullable
        private Query filter;

        public Builder field(@Nullable String field) {
            this.field = field;
            return this;
        }

        public Builder vector(@Nullable float[] vector) {
            this.vector = vector;
            return this;
        }

        public Builder k(@Nullable Integer k) {
            this.k = k;
            return this;
        }

        public Builder minScore(@Nullable Float minScore) {
            this.minScore = minScore;
            return this;
        }

        public Builder maxDistance(@Nullable Float maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public Builder filter(@Nullable Query filter) {
            this.filter = filter;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnQuery build() {
            this._checkSingleUse();
            return new KnnQuery(this);
        }
    }
}

