/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.snapshot.RepositorySettings;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Repository
implements PlainJsonSerializable {
    private final String type;
    @Nullable
    private final String uuid;
    private final RepositorySettings settings;
    public static final JsonpDeserializer<Repository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Repository::setupRepositoryDeserializer);

    private Repository(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.uuid = builder.uuid;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static Repository of(Function<Builder, ObjectBuilder<Repository>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final String uuid() {
        return this.uuid;
    }

    public final RepositorySettings settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Repository> {
        private String type;
        @Nullable
        private String uuid;
        private RepositorySettings settings;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        public final Builder settings(RepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        @Override
        public Repository build() {
            this._checkSingleUse();
            return new Repository(this);
        }
    }
}

