/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.recovery.RecoveryBytes;
import org.opensearch.client.opensearch.indices.recovery.RecoveryFiles;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RecoveryIndexStatus
implements PlainJsonSerializable {
    @Nullable
    private final RecoveryBytes bytes;
    private final RecoveryFiles files;
    private final RecoveryBytes size;
    @Nullable
    private final Time sourceThrottleTime;
    private final String sourceThrottleTimeInMillis;
    @Nullable
    private final Time targetThrottleTime;
    private final String targetThrottleTimeInMillis;
    private final String totalTimeInMillis;
    @Nullable
    private final Time totalTime;
    public static final JsonpDeserializer<RecoveryIndexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryIndexStatus::setupRecoveryIndexStatusDeserializer);

    private RecoveryIndexStatus(Builder builder) {
        this.bytes = builder.bytes;
        this.files = ApiTypeHelper.requireNonNull(builder.files, this, "files");
        this.size = ApiTypeHelper.requireNonNull(builder.size, this, "size");
        this.sourceThrottleTime = builder.sourceThrottleTime;
        this.sourceThrottleTimeInMillis = ApiTypeHelper.requireNonNull(builder.sourceThrottleTimeInMillis, this, "sourceThrottleTimeInMillis");
        this.targetThrottleTime = builder.targetThrottleTime;
        this.targetThrottleTimeInMillis = ApiTypeHelper.requireNonNull(builder.targetThrottleTimeInMillis, this, "targetThrottleTimeInMillis");
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
        this.totalTime = builder.totalTime;
    }

    public static RecoveryIndexStatus of(Function<Builder, ObjectBuilder<RecoveryIndexStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RecoveryBytes bytes() {
        return this.bytes;
    }

    public final RecoveryFiles files() {
        return this.files;
    }

    public final RecoveryBytes size() {
        return this.size;
    }

    @Nullable
    public final Time sourceThrottleTime() {
        return this.sourceThrottleTime;
    }

    public final String sourceThrottleTimeInMillis() {
        return this.sourceThrottleTimeInMillis;
    }

    @Nullable
    public final Time targetThrottleTime() {
        return this.targetThrottleTime;
    }

    public final String targetThrottleTimeInMillis() {
        return this.targetThrottleTimeInMillis;
    }

    public final String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.bytes != null) {
            generator.writeKey("bytes");
            this.bytes.serialize(generator, mapper);
        }
        generator.writeKey("files");
        this.files.serialize(generator, mapper);
        generator.writeKey("size");
        this.size.serialize(generator, mapper);
        if (this.sourceThrottleTime != null) {
            generator.writeKey("source_throttle_time");
            this.sourceThrottleTime.serialize(generator, mapper);
        }
        generator.writeKey("source_throttle_time_in_millis");
        generator.write(this.sourceThrottleTimeInMillis);
        if (this.targetThrottleTime != null) {
            generator.writeKey("target_throttle_time");
            this.targetThrottleTime.serialize(generator, mapper);
        }
        generator.writeKey("target_throttle_time_in_millis");
        generator.write(this.targetThrottleTimeInMillis);
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
    }

    protected static void setupRecoveryIndexStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bytes, RecoveryBytes._DESERIALIZER, "bytes");
        op.add(Builder::files, RecoveryFiles._DESERIALIZER, "files");
        op.add(Builder::size, RecoveryBytes._DESERIALIZER, "size");
        op.add(Builder::sourceThrottleTime, Time._DESERIALIZER, "source_throttle_time");
        op.add(Builder::sourceThrottleTimeInMillis, JsonpDeserializer.stringDeserializer(), "source_throttle_time_in_millis");
        op.add(Builder::targetThrottleTime, Time._DESERIALIZER, "target_throttle_time");
        op.add(Builder::targetThrottleTimeInMillis, JsonpDeserializer.stringDeserializer(), "target_throttle_time_in_millis");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RecoveryIndexStatus> {
        @Nullable
        private RecoveryBytes bytes;
        private RecoveryFiles files;
        private RecoveryBytes size;
        @Nullable
        private Time sourceThrottleTime;
        private String sourceThrottleTimeInMillis;
        @Nullable
        private Time targetThrottleTime;
        private String targetThrottleTimeInMillis;
        private String totalTimeInMillis;
        @Nullable
        private Time totalTime;

        public final Builder bytes(@Nullable RecoveryBytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder bytes(Function<RecoveryBytes.Builder, ObjectBuilder<RecoveryBytes>> fn) {
            return this.bytes(fn.apply(new RecoveryBytes.Builder()).build());
        }

        public final Builder files(RecoveryFiles value) {
            this.files = value;
            return this;
        }

        public final Builder files(Function<RecoveryFiles.Builder, ObjectBuilder<RecoveryFiles>> fn) {
            return this.files(fn.apply(new RecoveryFiles.Builder()).build());
        }

        public final Builder size(RecoveryBytes value) {
            this.size = value;
            return this;
        }

        public final Builder size(Function<RecoveryBytes.Builder, ObjectBuilder<RecoveryBytes>> fn) {
            return this.size(fn.apply(new RecoveryBytes.Builder()).build());
        }

        public final Builder sourceThrottleTime(@Nullable Time value) {
            this.sourceThrottleTime = value;
            return this;
        }

        public final Builder sourceThrottleTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.sourceThrottleTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder sourceThrottleTimeInMillis(String value) {
            this.sourceThrottleTimeInMillis = value;
            return this;
        }

        public final Builder targetThrottleTime(@Nullable Time value) {
            this.targetThrottleTime = value;
            return this;
        }

        public final Builder targetThrottleTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.targetThrottleTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder targetThrottleTimeInMillis(String value) {
            this.targetThrottleTimeInMillis = value;
            return this;
        }

        public final Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        @Override
        public RecoveryIndexStatus build() {
            this._checkSingleUse();
            return new RecoveryIndexStatus(this);
        }
    }
}

