/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.AggregationBreakdown;
import org.opensearch.client.opensearch.core.search.AggregationProfileDebug;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class AggregationProfile
implements PlainJsonSerializable {
    private final AggregationBreakdown breakdown;
    private final String description;
    private final long timeInNanos;
    private final String type;
    @Nullable
    private final AggregationProfileDebug debug;
    private final List<AggregationProfile> children;
    public static final JsonpDeserializer<AggregationProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregationProfile::setupAggregationProfileDeserializer);

    private AggregationProfile(Builder builder) {
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.debug = builder.debug;
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static AggregationProfile of(Function<Builder, ObjectBuilder<AggregationProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AggregationBreakdown breakdown() {
        return this.breakdown;
    }

    public final String description() {
        return this.description;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final AggregationProfileDebug debug() {
        return this.debug;
    }

    public final List<AggregationProfile> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.debug != null) {
            generator.writeKey("debug");
            this.debug.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (AggregationProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAggregationProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::breakdown, AggregationBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::debug, AggregationProfileDebug._DESERIALIZER, "debug");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AggregationProfile> {
        private AggregationBreakdown breakdown;
        private String description;
        private Long timeInNanos;
        private String type;
        @Nullable
        private AggregationProfileDebug debug;
        @Nullable
        private List<AggregationProfile> children;

        public final Builder breakdown(AggregationBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public final Builder breakdown(Function<AggregationBreakdown.Builder, ObjectBuilder<AggregationBreakdown>> fn) {
            return this.breakdown(fn.apply(new AggregationBreakdown.Builder()).build());
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder debug(@Nullable AggregationProfileDebug value) {
            this.debug = value;
            return this;
        }

        public final Builder debug(Function<AggregationProfileDebug.Builder, ObjectBuilder<AggregationProfileDebug>> fn) {
            return this.debug(fn.apply(new AggregationProfileDebug.Builder()).build());
        }

        public final Builder children(List<AggregationProfile> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(AggregationProfile value, AggregationProfile ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.children(fn.apply(new Builder()).build(), new AggregationProfile[0]);
        }

        @Override
        public AggregationProfile build() {
            this._checkSingleUse();
            return new AggregationProfile(this);
        }
    }
}

