/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.bulk.BulkOperationBase;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.util.ObjectBuilder;

public class UpdateOperationData<TDocument>
implements JsonpSerializable {
    @Nullable
    private final TDocument document;
    @Nullable
    private final Boolean docAsUpsert;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final Boolean detectNoop;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final Script script;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final SourceConfig source;

    private UpdateOperationData(Builder<TDocument> builder) {
        this.document = ((Builder)builder).document;
        this.docAsUpsert = ((Builder)builder).docAsUpsert;
        this.scriptedUpsert = ((Builder)builder).scriptedUpsert;
        this.detectNoop = ((Builder)builder).detectNoop;
        this.script = ((Builder)builder).script;
        this.upsert = ((Builder)builder).upsert;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.source = ((Builder)builder).source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert.booleanValue());
        }
        if (this.scriptedUpsert != null) {
            generator.writeKey("scripted_upsert");
            generator.write(this.scriptedUpsert.booleanValue());
        }
        if (this.detectNoop != null) {
            generator.writeKey("detect_noop");
            generator.write(this.detectNoop.booleanValue());
        }
        if (this.document != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
    }

    public static class Builder<TDocument>
    extends BulkOperationBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<UpdateOperationData<TDocument>> {
        @Nullable
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private Boolean docAsUpsert;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private Boolean detectNoop;
        @Nullable
        private TDocument upsert;
        @Nullable
        private Script script;
        @Nullable
        private SourceConfig source;

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public final Builder<TDocument> scriptedUpsert(@Nullable Boolean value) {
            this.scriptedUpsert = value;
            return this;
        }

        public final Builder<TDocument> detectNoop(@Nullable Boolean value) {
            this.detectNoop = value;
            return this;
        }

        public final Builder<TDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public final Builder<TDocument> script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder<TDocument> source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument> source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public UpdateOperationData<TDocument> build() {
            this._checkSingleUse();
            return new UpdateOperationData(this);
        }
    }
}

