/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.indices.DataStreamIndexInfo;
import org.opensearch.client.opensearch.indices.DataStreamTimestampField;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DataStreamInfo
implements JsonpSerializable {
    private final String name;
    private final DataStreamTimestampField timestampField;
    private final List<DataStreamIndexInfo> indices;
    private final int generation;
    private final HealthStatus status;
    private final String template;
    public static final JsonpDeserializer<DataStreamInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamInfo::setupDataStreamInfoDeserializer);

    private DataStreamInfo(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timestampField = ApiTypeHelper.requireNonNull(builder.timestampField, this, "timestampField");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.generation = ApiTypeHelper.requireNonNull(builder.generation, this, "generation");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
    }

    public static DataStreamInfo of(Function<Builder, ObjectBuilder<DataStreamInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final DataStreamTimestampField timestampField() {
        return this.timestampField;
    }

    public final List<DataStreamIndexInfo> indices() {
        return this.indices;
    }

    public final int generation() {
        return this.generation;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final String template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("timestamp_field");
        this.timestampField.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (DataStreamIndexInfo item : this.indices) {
                item.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("template");
        generator.write(this.template);
    }

    protected static void setupDataStreamInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::timestampField, DataStreamTimestampField._DESERIALIZER, "timestamp_field");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(DataStreamIndexInfo._DESERIALIZER), "indices");
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::template, JsonpDeserializer.stringDeserializer(), "template");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataStreamInfo> {
        private String name;
        private DataStreamTimestampField timestampField;
        private List<DataStreamIndexInfo> indices;
        private int generation;
        private HealthStatus status;
        private String template;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timestampField(DataStreamTimestampField value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampField(Function<DataStreamTimestampField.Builder, ObjectBuilder<DataStreamTimestampField>> fn) {
            return this.timestampField(fn.apply(new DataStreamTimestampField.Builder()).build());
        }

        public final Builder indices(List<DataStreamIndexInfo> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(DataStreamIndexInfo value, DataStreamIndexInfo ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder template(String value) {
            this.template = value;
            return this;
        }

        @Override
        public DataStreamInfo build() {
            this._checkSingleUse();
            return new DataStreamInfo(this);
        }
    }
}

