/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.reindex_rethrottle.ReindexNode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

// typedef: _global.reindex_rethrottle.Response

@JsonpDeserializable
public class ReindexRethrottleResponse implements JsonpSerializable {
    private final Map<String, ReindexNode> nodes;

    // ---------------------------------------------------------------------------------------------

    private ReindexRethrottleResponse(Builder builder) {

        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, this, "nodes");

    }

    public static ReindexRethrottleResponse of(Function<Builder, ObjectBuilder<ReindexRethrottleResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Required - API name: {@code nodes}
     */
    public final Map<String, ReindexNode> nodes() {
        return this.nodes;
    }

    /**
     * Serialize this object to JSON.
     */
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, ReindexNode> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);

            }
            generator.writeEnd();

        }

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link ReindexRethrottleResponse}.
     */

    public static class Builder extends ObjectBuilderBase implements ObjectBuilder<ReindexRethrottleResponse> {
        private Map<String, ReindexNode> nodes;

        /**
         * Required - API name: {@code nodes}
         * <p>
         * Adds all entries of <code>map</code> to <code>nodes</code>.
         */
        public final Builder nodes(Map<String, ReindexNode> map) {
            this.nodes = _mapPutAll(this.nodes, map);
            return this;
        }

        /**
         * Required - API name: {@code nodes}
         * <p>
         * Adds an entry to <code>nodes</code>.
         */
        public final Builder nodes(String key, ReindexNode value) {
            this.nodes = _mapPut(this.nodes, key, value);
            return this;
        }

        /**
         * Required - API name: {@code nodes}
         * <p>
         * Adds an entry to <code>nodes</code> using a builder lambda.
         */
        public final Builder nodes(String key, Function<ReindexNode.Builder, ObjectBuilder<ReindexNode>> fn) {
            return nodes(key, fn.apply(new ReindexNode.Builder()).build());
        }

        /**
         * Builds a {@link ReindexRethrottleResponse}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public ReindexRethrottleResponse build() {
            _checkSingleUse();

            return new ReindexRethrottleResponse(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link ReindexRethrottleResponse}
     */
    public static final JsonpDeserializer<ReindexRethrottleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        ReindexRethrottleResponse::setupReindexRethrottleResponseDeserializer
    );

    protected static void setupReindexRethrottleResponseDeserializer(ObjectDeserializer<ReindexRethrottleResponse.Builder> op) {

        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(ReindexNode._DESERIALIZER), "nodes");

    }

}
