/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.KeyValue;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class KeyValueSchemaValidator
implements Validator<KeyValue> {
    @Override
    public void validate(KeyValue xmlObject) throws ValidationException {
        this.validateChildrenPresence(xmlObject);
        this.validateExtensionChildNamespace(xmlObject);
    }

    protected void validateChildrenPresence(KeyValue xmlObject) throws ValidationException {
        List<XMLObject> children = xmlObject.getOrderedChildren();
        if (children == null || children.isEmpty()) {
            throw new ValidationException("No children were present in the KeyValue object");
        }
        if (children.size() > 1) {
            throw new ValidationException("Invalid number of children were present in the KeyValue object");
        }
    }

    protected void validateExtensionChildNamespace(KeyValue xmlObject) throws ValidationException {
        XMLObject unknownChild = xmlObject.getUnknownXMLObject();
        if (unknownChild == null) {
            return;
        }
        QName childName = unknownChild.getElementQName();
        if ("http://www.w3.org/2000/09/xmldsig#".equals(childName.getNamespaceURI())) {
            throw new ValidationException("KeyValue contains an illegal child extension element: " + childName);
        }
    }
}

