/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.util.DatatypeHelper;

public final class X509DigestCriteria
implements Criteria {
    private String algorithm;
    private byte[] x509digest;

    public X509DigestCriteria(String alg, byte[] digest) {
        this.setAlgorithm(alg);
        this.setDigest(digest);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String alg) {
        if (DatatypeHelper.isEmpty(alg)) {
            throw new IllegalArgumentException("Digest algorithm criteria value cannot be null or empty");
        }
        this.algorithm = DatatypeHelper.safeTrimOrNullString(alg);
    }

    public byte[] getDigest() {
        return this.x509digest;
    }

    public void setDigest(byte[] digest) {
        if (digest == null || digest.length == 0) {
            throw new IllegalArgumentException("Certificate digest criteria value cannot be null or empty");
        }
        this.x509digest = digest;
    }
}

