/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509SubjectKeyIdentifierCriteria;
import org.opensaml.xml.security.x509.X509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509SubjectKeyIdentifierCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509SubjectKeyIdentifierCredentialCriteria.class);
    private byte[] ski;

    public EvaluableX509SubjectKeyIdentifierCredentialCriteria(X509SubjectKeyIdentifierCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.ski = criteria.getSubjectKeyIdentifier();
    }

    public EvaluableX509SubjectKeyIdentifierCredentialCriteria(byte[] newSKI) {
        if (newSKI == null || newSKI.length == 0) {
            throw new IllegalArgumentException("Subject key identifier may not be null or empty");
        }
        this.ski = newSKI;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy subject key identifier criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, does not satisfy criteria");
            return Boolean.FALSE;
        }
        byte[] credSKI = X509Util.getSubjectKeyIdentifier(entityCert);
        if (credSKI == null || credSKI.length == 0) {
            this.log.info("Could not evaluate criteria, certificate contained no subject key identifier extension");
            return null;
        }
        Boolean result = Arrays.equals(this.ski, credSKI);
        return result;
    }
}

