/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption.validator;

import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.EncryptionProperty;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class EncryptionPropertySchemaValidator
implements Validator<EncryptionProperty> {
    @Override
    public void validate(EncryptionProperty xmlObject) throws ValidationException {
        this.validateUnknownChildren(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
        this.validateAttributeNamespaces(xmlObject);
    }

    protected void validateUnknownChildren(EncryptionProperty xmlObject) throws ValidationException {
        if (xmlObject.getUnknownXMLObjects().isEmpty()) {
            throw new ValidationException("No children were present in the EncryptionProperty object");
        }
    }

    protected void validateChildrenNamespaces(EncryptionProperty xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getUnknownXMLObjects()) {
            QName childName = child.getElementQName();
            if (!"http://www.w3.org/2001/04/xmlenc#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("EncryptionProperty contains an illegal child extension element: " + childName);
        }
    }

    protected void validateAttributeNamespaces(EncryptionProperty xmlObject) throws ValidationException {
        for (QName attribName : xmlObject.getUnknownAttributes().keySet()) {
            if ("http://www.w3.org/XML/1998/namespace".equals(attribName.getNamespaceURI())) continue;
            throw new ValidationException("EncryptionProperty contains an illegal extension attribute: " + attribName);
        }
    }
}

