/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.util.Collection;
import java.util.List;
import org.openrewrite.jgit.transport.PreReceiveHook;
import org.openrewrite.jgit.transport.ReceiveCommand;
import org.openrewrite.jgit.transport.ReceivePack;

public class PreReceiveHookChain
implements PreReceiveHook {
    private final PreReceiveHook[] hooks;
    private final int count;

    public static PreReceiveHook newChain(List<? extends PreReceiveHook> hooks) {
        PreReceiveHook[] newHooks = new PreReceiveHook[hooks.size()];
        int i = 0;
        for (PreReceiveHook preReceiveHook : hooks) {
            if (preReceiveHook == PreReceiveHook.NULL) continue;
            newHooks[i++] = preReceiveHook;
        }
        switch (i) {
            case 0: {
                return PreReceiveHook.NULL;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new PreReceiveHookChain(newHooks, i);
    }

    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onPreReceive(rp, commands);
        }
    }

    private PreReceiveHookChain(PreReceiveHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

