/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.internal.storage.file.CachedObjectDirectory;
import org.openrewrite.jgit.internal.storage.file.FileObjectDatabase;
import org.openrewrite.jgit.internal.storage.file.FileRepository;
import org.openrewrite.jgit.internal.storage.file.FileSnapshot;
import org.openrewrite.jgit.internal.storage.file.LooseObjects;
import org.openrewrite.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.openrewrite.jgit.internal.storage.file.Pack;
import org.openrewrite.jgit.internal.storage.file.PackDirectory;
import org.openrewrite.jgit.internal.storage.file.PackFile;
import org.openrewrite.jgit.internal.storage.file.PackInserter;
import org.openrewrite.jgit.internal.storage.file.WindowCursor;
import org.openrewrite.jgit.internal.storage.pack.ObjectToPack;
import org.openrewrite.jgit.internal.storage.pack.PackExt;
import org.openrewrite.jgit.internal.storage.pack.PackWriter;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.Config;
import org.openrewrite.jgit.lib.ObjectDatabase;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.RepositoryCache;
import org.openrewrite.jgit.util.FS;
import org.openrewrite.jgit.util.FileUtils;

public class ObjectDirectory
extends FileObjectDatabase {
    private static final int RESOLVE_ABBREV_LIMIT = 256;
    private final AlternateHandle handle = new AlternateHandle(this);
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final LooseObjects loose;
    private final PackDirectory packed;
    private final PackDirectory preserved;
    private final File alternatesFile;
    private final FS fs;
    private final AtomicReference<AlternateHandle[]> alternates;
    private final File shallowFile;
    private FileSnapshot shallowFileSnapshot = FileSnapshot.DIRTY;
    private Set<ObjectId> shallowCommitsIds;

    public ObjectDirectory(Config cfg, File dir, File[] alternatePaths, FS fs, File shallowFile) throws IOException {
        this.config = cfg;
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        File packDirectory = new File(this.objects, "pack");
        File preservedDirectory = new File(packDirectory, "preserved");
        this.alternatesFile = new File(this.objects, "info/alternates");
        this.loose = new LooseObjects(this.objects);
        this.packed = new PackDirectory(this.config, packDirectory);
        this.preserved = new PackDirectory(this.config, preservedDirectory);
        this.fs = fs;
        this.shallowFile = shallowFile;
        this.alternates = new AtomicReference();
        if (alternatePaths != null) {
            AlternateHandle[] alt = new AlternateHandle[alternatePaths.length];
            for (int i = 0; i < alternatePaths.length; ++i) {
                alt[i] = this.openAlternate(alternatePaths[i]);
            }
            this.alternates.set(alt);
        }
    }

    @Override
    public final File getDirectory() {
        return this.loose.getDirectory();
    }

    public final File getPackDirectory() {
        return this.packed.getDirectory();
    }

    public final File getPreservedDirectory() {
        return this.preserved.getDirectory();
    }

    @Override
    public boolean exists() {
        return this.fs.exists(this.objects);
    }

    @Override
    public void create() throws IOException {
        this.loose.create();
        FileUtils.mkdir(this.infoDirectory);
        this.packed.create();
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    public PackInserter newPackInserter() {
        return new PackInserter(this);
    }

    @Override
    public void close() {
        this.loose.close();
        this.packed.close();
        AlternateHandle[] alt = this.alternates.get();
        if (alt != null && this.alternates.compareAndSet(alt, null)) {
            for (AlternateHandle od : alt) {
                od.close();
            }
        }
    }

    @Override
    public Collection<Pack> getPacks() {
        return this.packed.getPacks();
    }

    @Override
    public Pack openPack(File pack) throws IOException {
        PackFile pf;
        try {
            pf = new PackFile(pack);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack), e);
        }
        String p = pf.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !pf.getPackExt().equals((Object)PackExt.PACK)) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack));
        }
        PackFile bitmapIdx = pf.create(PackExt.BITMAP_INDEX);
        Pack res = new Pack(pack, bitmapIdx.exists() ? bitmapIdx : null);
        this.packed.insert(res);
        return res;
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    public boolean has(AnyObjectId objectId) {
        return this.loose.hasCached(objectId) || this.hasPackedOrLooseInSelfOrAlternate(objectId) || this.restoreFromSelfOrAlternate(objectId, null) && this.hasPackedOrLooseInSelfOrAlternate(objectId);
    }

    private boolean hasPackedOrLooseInSelfOrAlternate(AnyObjectId objectId) {
        return this.hasPackedInSelfOrAlternate(objectId, null) || this.hasLooseInSelfOrAlternate(objectId, null);
    }

    private boolean hasPackedInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.hasPackedObject(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || !alt.db.hasPackedInSelfOrAlternate(objectId, skips)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLooseInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.loose.has(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || !alt.db.hasLooseInSelfOrAlternate(objectId, skips)) continue;
            return true;
        }
        return false;
    }

    boolean hasPackedObject(AnyObjectId objectId) {
        return this.packed.has(objectId);
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.resolve(matches, id, null);
    }

    private void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        if (!this.packed.resolve(matches, id, 256)) {
            return;
        }
        if (!this.loose.resolve(matches, id, 256)) {
            return;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId())) continue;
            alt.db.resolve(matches, id, skips);
            if (matches.size() <= 256) continue;
            return;
        }
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObjectWithoutRestoring(curs, objectId);
        if (ldr == null && this.restoreFromSelfOrAlternate(objectId, null)) {
            ldr = this.openObjectWithoutRestoring(curs, objectId);
        }
        return ldr;
    }

    private ObjectLoader openObjectWithoutRestoring(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr;
        if (this.loose.hasCached(objectId) && (ldr = this.openLooseObject(curs, objectId)) != null) {
            return ldr;
        }
        ldr = this.openPackedFromSelfOrAlternate(curs, objectId, null);
        if (ldr != null) {
            return ldr;
        }
        return this.openLooseFromSelfOrAlternate(curs, objectId, null);
    }

    private ObjectLoader openPackedFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        ObjectLoader ldr = this.openPackedObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || (ldr = alt.db.openPackedFromSelfOrAlternate(curs, objectId, skips)) == null) continue;
            return ldr;
        }
        return null;
    }

    private ObjectLoader openLooseFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) throws IOException {
        ObjectLoader ldr = this.openLooseObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || (ldr = alt.db.openLooseFromSelfOrAlternate(curs, objectId, skips)) == null) continue;
            return ldr;
        }
        return null;
    }

    ObjectLoader openPackedObject(WindowCursor curs, AnyObjectId objectId) {
        return this.packed.open(curs, objectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor curs, AnyObjectId id) throws IOException {
        return this.loose.open(curs, id);
    }

    @Override
    long getObjectSize(WindowCursor curs, AnyObjectId id) throws IOException {
        long sz = this.getObjectSizeWithoutRestoring(curs, id);
        if (0L > sz && this.restoreFromSelfOrAlternate(id, null)) {
            sz = this.getObjectSizeWithoutRestoring(curs, id);
        }
        return sz;
    }

    private long getObjectSizeWithoutRestoring(WindowCursor curs, AnyObjectId id) throws IOException {
        long len;
        if (this.loose.hasCached(id) && 0L <= (len = this.loose.getSize(curs, id))) {
            return len;
        }
        len = this.getPackedSizeFromSelfOrAlternate(curs, id, null);
        if (0L <= len) {
            return len;
        }
        return this.getLooseSizeFromSelfOrAlternate(curs, id, null);
    }

    private long getPackedSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) {
        long len = this.packed.getSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || 0L > (len = alt.db.getPackedSizeFromSelfOrAlternate(curs, id, skips))) continue;
            return len;
        }
        return -1L;
    }

    private long getLooseSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        long len = this.loose.getSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || 0L > (len = alt.db.getLooseSizeFromSelfOrAlternate(curs, id, skips))) continue;
            return len;
        }
        return -1L;
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.selectObjectRepresentation(packer, otp, curs, null);
    }

    private void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs, Set<AlternateHandle.Id> skips) throws IOException {
        this.packed.selectRepresentation(packer, otp, curs);
        skips = this.addMe(skips);
        for (AlternateHandle h : this.myAlternates()) {
            if (skips.contains(h.getId())) continue;
            h.db.selectObjectRepresentation(packer, otp, curs, skips);
        }
    }

    private boolean restoreFromSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.restoreFromSelf(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        for (AlternateHandle alt : this.myAlternates()) {
            if (skips.contains(alt.getId()) || !alt.db.restoreFromSelfOrAlternate(objectId, skips)) continue;
            return true;
        }
        return false;
    }

    private boolean restoreFromSelf(AnyObjectId objectId) {
        Pack preservedPack = this.preserved.getPack(objectId);
        if (preservedPack == null) {
            return false;
        }
        PackFile preservedFile = new PackFile(preservedPack.getPackFile());
        for (PackExt ext : PackExt.values()) {
            if (PackExt.INDEX.equals((Object)ext)) continue;
            this.restore(preservedFile.create(ext));
        }
        this.restore(preservedFile.create(PackExt.INDEX));
        return true;
    }

    private boolean restore(PackFile preservedPack) {
        PackFile restored = preservedPack.createForDirectory(this.packed.getDirectory());
        try {
            Files.createLink(restored.toPath(), preservedPack.toPath());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException {
        if (this.loose.hasCached(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        return this.loose.insert(tmp, id);
    }

    @Override
    Config getConfig() {
        return this.config;
    }

    @Override
    FS getFS() {
        return this.fs;
    }

    /*
     * Exception decompiling
     */
    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void closeAllPackHandles(File packFile) {
        if (packFile.exists()) {
            for (Pack p : this.packed.getPacks()) {
                if (!packFile.getPath().equals(p.getPackFile().getPath())) continue;
                p.close();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlternateHandle[] myAlternates() {
        AlternateHandle[] alt = this.alternates.get();
        if (alt == null) {
            AtomicReference<AlternateHandle[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                alt = this.alternates.get();
                if (alt == null) {
                    try {
                        alt = this.loadAlternates();
                    }
                    catch (IOException e) {
                        alt = new AlternateHandle[]{};
                    }
                    this.alternates.set(alt);
                }
            }
        }
        return alt;
    }

    Set<AlternateHandle.Id> addMe(Set<AlternateHandle.Id> skips) {
        if (skips == null) {
            skips = new HashSet<AlternateHandle.Id>();
        }
        skips.add(this.handle.getId());
        return skips;
    }

    private AlternateHandle[] loadAlternates() throws IOException {
        ArrayList<AlternateHandle> l = new ArrayList<AlternateHandle>(4);
        try (BufferedReader br = ObjectDirectory.open(this.alternatesFile);){
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
        }
        return l.toArray(new AlternateHandle[0]);
    }

    private static BufferedReader open(File f) throws IOException, FileNotFoundException {
        return Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);
    }

    private AlternateHandle openAlternate(String location) throws IOException {
        File objdir = this.fs.resolve(this.objects, location);
        return this.openAlternate(objdir);
    }

    private AlternateHandle openAlternate(File objdir) throws IOException {
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent, this.fs)) {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(parent, this.fs);
            FileRepository db = (FileRepository)RepositoryCache.open(key);
            return new AlternateRepository(db);
        }
        ObjectDirectory db = new ObjectDirectory(this.config, objdir, null, this.fs, null);
        return new AlternateHandle(db);
    }

    @Override
    public File fileFor(AnyObjectId objectId) {
        return this.loose.fileFor(objectId);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    CachedObjectDirectory newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    AlternateHandle.Id getAlternateId() {
        return new AlternateHandle.Id(this.objects);
    }

    static class AlternateRepository
    extends AlternateHandle {
        final FileRepository repository;

        AlternateRepository(FileRepository r) {
            super(r.getObjectDatabase());
            this.repository = r;
        }

        @Override
        void close() {
            this.repository.close();
        }
    }

    static class AlternateHandle {
        final ObjectDirectory db;

        AlternateHandle(ObjectDirectory db) {
            this.db = db;
        }

        void close() {
            this.db.close();
        }

        public Id getId() {
            return this.db.getAlternateId();
        }

        static class Id {
            String alternateId;

            public Id(File object) {
                try {
                    this.alternateId = object.getCanonicalPath();
                }
                catch (Exception e) {
                    this.alternateId = null;
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (o == null || !(o instanceof Id)) {
                    return false;
                }
                Id aId = (Id)o;
                return Objects.equals(this.alternateId, aId.alternateId);
            }

            public int hashCode() {
                if (this.alternateId == null) {
                    return 1;
                }
                return this.alternateId.hashCode();
            }
        }
    }
}

