/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.NoFilepatternException;
import org.openrewrite.jgit.dircache.DirCache;
import org.openrewrite.jgit.dircache.DirCacheBuildIterator;
import org.openrewrite.jgit.dircache.DirCacheBuilder;
import org.openrewrite.jgit.events.WorkingTreeModifiedEvent;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.treewalk.TreeWalk;
import org.openrewrite.jgit.treewalk.filter.PathFilterGroup;

public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private boolean cached = false;

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public RmCommand setCached(boolean cached) {
        this.checkCallable();
        this.cached = cached;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        ArrayList<String> actuallyDeletedFiles = new ArrayList<String>();
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.reset();
            tw.setRecursive(true);
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            tw.addTree(new DirCacheBuildIterator(builder));
            while (tw.next()) {
                FileMode mode;
                if (this.cached || (mode = tw.getFileMode(0)).getObjectType() != 3) continue;
                String relativePath = tw.getPathString();
                File path = new File(this.repo.getWorkTree(), relativePath);
                if (!this.delete(path)) continue;
                actuallyDeletedFiles.add(relativePath);
            }
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e);
        }
        finally {
            try {
                if (dc != null) {
                    dc.unlock();
                }
            }
            finally {
                if (!actuallyDeletedFiles.isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(null, actuallyDeletedFiles));
                }
            }
        }
        return dc;
    }

    private boolean delete(File p) {
        boolean deleted = false;
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            deleted = true;
            p = p.getParentFile();
        }
        return deleted;
    }
}

