/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.RefNotFoundException;
import org.openrewrite.jgit.errors.InvalidPatternException;
import org.openrewrite.jgit.fnmatch.FileNameMatcher;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevFlag;
import org.openrewrite.jgit.revwalk.RevFlagSet;
import org.openrewrite.jgit.revwalk.RevTag;
import org.openrewrite.jgit.revwalk.RevWalk;

public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;
    private List<FileNameMatcher> matchers = new ArrayList<FileNameMatcher>();
    private boolean useAll;
    private boolean useTags;
    private boolean always;
    private final Comparator<Ref> TAG_TIE_BREAKER = new Comparator<Ref>(){

        @Override
        public int compare(Ref o1, Ref o2) {
            try {
                return this.tagDate(o2).compareTo(this.tagDate(o1));
            }
            catch (IOException e) {
                return 0;
            }
        }

        private Date tagDate(Ref tag) throws IOException {
            RevTag t = DescribeCommand.this.w.parseTag(tag.getObjectId());
            DescribeCommand.this.w.parseBody(t);
            return t.getTaggerIdent().getWhen();
        }
    };

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id = this.repo.resolve(rev);
        if (id == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id);
    }

    public DescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    public DescribeCommand setAll(boolean all) {
        this.useAll = all;
        return this;
    }

    public DescribeCommand setTags(boolean tags) {
        this.useTags = tags;
        return this;
    }

    public DescribeCommand setAlways(boolean always) {
        this.always = always;
        return this;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", this.formatRefName(tag.getName()), depth, this.w.getObjectReader().abbreviate(tip).name());
    }

    public DescribeCommand setMatch(String ... patterns) throws InvalidPatternException {
        for (String p : patterns) {
            this.matchers.add(new FileNameMatcher(p, null));
        }
        return this;
    }

    private Optional<Ref> getBestMatch(List<Ref> tags) {
        if (tags == null || tags.isEmpty()) {
            return Optional.empty();
        }
        if (this.matchers.isEmpty()) {
            Collections.sort(tags, this.TAG_TIE_BREAKER);
            return Optional.of(tags.get(0));
        }
        Stream<Ref> matchingTags = Stream.empty();
        for (FileNameMatcher matcher : this.matchers) {
            Stream<Ref> m = tags.stream().filter(tag -> {
                matcher.append(this.formatRefName(tag.getName()));
                boolean result = matcher.isMatch();
                matcher.reset();
                return result;
            });
            matchingTags = Stream.of(matchingTags, m).flatMap(i -> i);
        }
        return matchingTags.sorted(this.TAG_TIE_BREAKER).findFirst();
    }

    private ObjectId getObjectIdFromRef(Ref r) throws JGitInternalException {
        try {
            ObjectId key = this.repo.getRefDatabase().peel(r).getPeeledObjectId();
            if (key == null) {
                key = r.getObjectId();
            }
            return key;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    @Override
    public String call() throws GitAPIException {
        try {
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag) {
                    this.tag = tag;
                    this.flag = DescribeCommand.this.w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    DescribeCommand.this.w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                String describe(ObjectId tip) throws IOException {
                    return DescribeCommand.this.longDescription(this.tag, this.depth, tip);
                }
            }
            Object cd;
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            List<Ref> tagList = this.repo.getRefDatabase().getRefsByPrefix(this.useAll ? "refs/" : "refs/tags/");
            Map<ObjectId, List<Ref>> tags = tagList.stream().filter(this::filterLightweightTags).collect(Collectors.groupingBy(this::getObjectIdFromRef));
            final RevFlagSet allFlags = new RevFlagSet();
            ArrayList<Object> candidates = new ArrayList<Object>();
            Optional<Ref> bestMatch = this.getBestMatch(tags.get(this.target));
            if (bestMatch.isPresent()) {
                String string = this.longDesc ? this.longDescription(bestMatch.get(), 0, this.target) : this.formatRefName(bestMatch.get().getName());
                return string;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                if (!c.hasAny(allFlags) && (bestMatch = this.getBestMatch(tags.get(c))).isPresent()) {
                    cd = new Candidate(c, bestMatch.get());
                    candidates.add(cd);
                    ((Candidate)cd).depth = seen;
                }
                for (Candidate candidate : candidates) {
                    if (candidate.reaches(c)) continue;
                    ++candidate.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate candidate : candidates) {
                    if (candidate.reaches(c)) continue;
                    ++candidate.depth;
                }
            }
            if (candidates.isEmpty()) {
                cd = this.always ? this.w.getObjectReader().abbreviate(this.target).name() : null;
                return cd;
            }
            Candidate best = (Candidate)Collections.min(candidates, (o1, o2) -> o1.depth - o2.depth);
            String string = best.describe(this.target);
            return string;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }

    private String formatRefName(String name) {
        return name.startsWith("refs/tags/") ? name.substring("refs/tags/".length()) : name.substring("refs/".length());
    }

    private boolean filterLightweightTags(Ref ref) {
        ObjectId id = ref.getObjectId();
        try {
            return this.useAll || this.useTags || id != null && this.w.parseTag(id) != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

