/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class Collections {
    private Collections() {
    }

    public static <T> Set<T> setOf(Collection<T> c) {
        return new LinkedHashSet<T>(c);
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static <T> boolean containsAny(Iterable<T> haystack, Iterable<T> needles) {
        if (haystack == null || needles == null) {
            return false;
        }
        for (T straw : haystack) {
            for (T needle : needles) {
                if (!straw.equals(needle)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Collection<? extends T> filteredCopyOf(Collection<? extends T> source, Collection<? extends T> filter) {
        LinkedList<Object> copy = source != null ? new LinkedList<T>(source) : new LinkedList();
        if (filter != null) {
            copy.removeAll(new ArrayList<T>(filter));
        }
        return copy;
    }

    public static <T> T firstElementOf(Collection<? extends T> items) {
        if (items != null && !items.isEmpty()) {
            return items.iterator().next();
        }
        return null;
    }
}

