/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.introspection;

import de.danielbechler.diff.instantiation.TypeInfo;
import de.danielbechler.diff.introspection.Introspector;
import de.danielbechler.diff.introspection.PropertyAccessor;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Exceptions;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class StandardIntrospector
implements Introspector {
    @Override
    public TypeInfo introspect(Class<?> type) {
        Assert.notNull(type, "type");
        try {
            return this.internalIntrospect(type);
        }
        catch (IntrospectionException e) {
            throw Exceptions.escalate(e);
        }
    }

    private TypeInfo internalIntrospect(Class<?> type) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        TypeInfo typeInfo = new TypeInfo(type);
        for (PropertyDescriptor descriptor : descriptors = this.getBeanInfo(type).getPropertyDescriptors()) {
            if (StandardIntrospector.shouldSkip(descriptor)) continue;
            String propertyName = descriptor.getName();
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            PropertyAccessor accessor = new PropertyAccessor(propertyName, readMethod, writeMethod);
            typeInfo.addPropertyAccessor(accessor);
        }
        return typeInfo;
    }

    protected BeanInfo getBeanInfo(Class<?> type) throws IntrospectionException {
        return java.beans.Introspector.getBeanInfo(type);
    }

    private static boolean shouldSkip(PropertyDescriptor descriptor) {
        if (descriptor.getName().equals("class")) {
            return true;
        }
        if (descriptor.getName().equals("metaClass")) {
            return true;
        }
        return descriptor.getReadMethod() == null;
    }
}

