/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.DefaultNodeQueryService;
import de.danielbechler.diff.NodeQueryService;
import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.category.CategoryConfigurer;
import de.danielbechler.diff.category.CategoryService;
import de.danielbechler.diff.circular.CircularReferenceConfigurer;
import de.danielbechler.diff.circular.CircularReferenceService;
import de.danielbechler.diff.comparison.ComparisonConfigurer;
import de.danielbechler.diff.comparison.ComparisonService;
import de.danielbechler.diff.differ.BeanDiffer;
import de.danielbechler.diff.differ.CollectionDiffer;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferConfigurer;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.differ.DifferFactory;
import de.danielbechler.diff.differ.DifferProvider;
import de.danielbechler.diff.differ.DifferService;
import de.danielbechler.diff.differ.MapDiffer;
import de.danielbechler.diff.differ.PrimitiveDiffer;
import de.danielbechler.diff.filtering.FilteringConfigurer;
import de.danielbechler.diff.filtering.ReturnableNodeService;
import de.danielbechler.diff.identity.IdentityService;
import de.danielbechler.diff.inclusion.InclusionConfigurer;
import de.danielbechler.diff.inclusion.InclusionService;
import de.danielbechler.diff.introspection.IntrospectionConfigurer;
import de.danielbechler.diff.introspection.IntrospectionService;
import java.util.ArrayList;
import java.util.Collection;

public class ObjectDifferBuilder {
    private final IntrospectionService introspectionService = new IntrospectionService(this);
    private final CategoryService categoryService = new CategoryService(this);
    private final InclusionService inclusionService = new InclusionService(this.categoryService, this);
    private final ComparisonService comparisonService = new ComparisonService(this);
    private final IdentityService identityService = new IdentityService(this);
    private final ReturnableNodeService returnableNodeService = new ReturnableNodeService(this);
    private final CircularReferenceService circularReferenceService = new CircularReferenceService(this);
    private final DifferService differService = new DifferService(this);
    private final NodeQueryService nodeQueryService = new DefaultNodeQueryService(this.categoryService, this.introspectionService, this.inclusionService, this.returnableNodeService, this.comparisonService, this.comparisonService);

    private ObjectDifferBuilder() {
    }

    public FilteringConfigurer filtering() {
        return this.returnableNodeService;
    }

    public IntrospectionConfigurer introspection() {
        return this.introspectionService;
    }

    public CircularReferenceConfigurer circularReferenceHandling() {
        return this.circularReferenceService;
    }

    public InclusionConfigurer inclusion() {
        return this.inclusionService;
    }

    public ComparisonConfigurer comparison() {
        return this.comparisonService;
    }

    public IdentityService identity() {
        return this.identityService;
    }

    public CategoryConfigurer categories() {
        return this.categoryService;
    }

    public DifferConfigurer differs() {
        return this.differService;
    }

    public static ObjectDiffer buildDefault() {
        return ObjectDifferBuilder.startBuilding().build();
    }

    public static ObjectDifferBuilder startBuilding() {
        return new ObjectDifferBuilder();
    }

    public ObjectDiffer build() {
        DifferProvider differProvider = new DifferProvider();
        DifferDispatcher differDispatcher = this.newDifferDispatcher(differProvider);
        differProvider.push(this.newBeanDiffer(differDispatcher));
        differProvider.push(this.newCollectionDiffer(differDispatcher));
        differProvider.push(this.newMapDiffer(differDispatcher));
        differProvider.push(this.newPrimitiveDiffer());
        differProvider.pushAll(this.createCustomDiffers(differDispatcher));
        return new ObjectDiffer(differDispatcher);
    }

    private DifferDispatcher newDifferDispatcher(DifferProvider differProvider) {
        return new DifferDispatcher(differProvider, this.circularReferenceService, this.circularReferenceService, this.inclusionService, this.returnableNodeService, this.introspectionService, this.categoryService);
    }

    private Differ newBeanDiffer(DifferDispatcher differDispatcher) {
        return new BeanDiffer(differDispatcher, this.introspectionService, this.returnableNodeService, this.comparisonService, this.introspectionService);
    }

    private Differ newCollectionDiffer(DifferDispatcher differDispatcher) {
        return new CollectionDiffer(differDispatcher, this.comparisonService, this.identityService);
    }

    private Differ newMapDiffer(DifferDispatcher differDispatcher) {
        return new MapDiffer(differDispatcher, this.comparisonService);
    }

    private Differ newPrimitiveDiffer() {
        return new PrimitiveDiffer(this.comparisonService);
    }

    private Iterable<Differ> createCustomDiffers(DifferDispatcher differDispatcher) {
        Collection<DifferFactory> differFactories = this.differService.getDifferFactories();
        ArrayList<Differ> differs = new ArrayList<Differ>(differFactories.size());
        for (DifferFactory differFactory : differFactories) {
            differs.add(differFactory.createDiffer(differDispatcher, this.nodeQueryService));
        }
        return differs;
    }
}

