/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal.rpc;

import org.openrewrite.Tree;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlSender
extends YamlVisitor<RpcSendQueue> {
    public Yaml preVisit(Yaml y, RpcSendQueue q) {
        q.getAndSend((Object)y, Tree::getId);
        q.getAndSend((Object)y, Yaml::getPrefix);
        q.getAndSend((Object)y, Tree::getMarkers);
        return y;
    }

    @Override
    public Yaml visitDocuments(Yaml.Documents documents, RpcSendQueue q) {
        q.getAndSend((Object)documents, d -> d.getSourcePath().toString());
        q.getAndSend((Object)documents, d -> d.getCharset().name());
        q.getAndSend((Object)documents, Yaml.Documents::isCharsetBomMarked);
        q.getAndSend((Object)documents, Yaml.Documents::getChecksum);
        q.getAndSend((Object)documents, Yaml.Documents::getFileAttributes);
        q.getAndSendList((Object)documents, Yaml.Documents::getDocuments, doc -> doc.getId(), doc -> this.visit((Tree)doc, q));
        q.getAndSend((Object)documents, Yaml.Documents::getSuffix);
        return documents;
    }

    @Override
    public Yaml visitDocument(Yaml.Document document, RpcSendQueue q) {
        q.getAndSend((Object)document, Yaml.Document::isExplicit);
        q.getAndSend((Object)document, Yaml.Document::getBlock, b -> this.visit((Tree)b, q));
        q.getAndSend((Object)document, Yaml.Document::getEnd, e -> this.visit((Tree)e, q));
        return document;
    }

    @Override
    public Yaml visitDocumentEnd(Yaml.Document.End end, RpcSendQueue q) {
        q.getAndSend((Object)end, Yaml.Document.End::isExplicit);
        return end;
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, RpcSendQueue q) {
        q.getAndSend((Object)mapping, Yaml.Mapping::getOpeningBracePrefix);
        q.getAndSendList((Object)mapping, Yaml.Mapping::getEntries, e -> e.getId(), e -> this.visit((Tree)e, q));
        q.getAndSend((Object)mapping, Yaml.Mapping::getClosingBracePrefix);
        q.getAndSend((Object)mapping, Yaml.Mapping::getAnchor, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)mapping, Yaml.Mapping::getTag, t -> this.visit((Tree)t, q));
        return mapping;
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, RpcSendQueue q) {
        q.getAndSend((Object)entry, Yaml.Mapping.Entry::getKey, k -> this.visit((Tree)k, q));
        q.getAndSend((Object)entry, Yaml.Mapping.Entry::getBeforeMappingValueIndicator);
        q.getAndSend((Object)entry, Yaml.Mapping.Entry::getValue, v -> this.visit((Tree)v, q));
        return entry;
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, RpcSendQueue q) {
        q.getAndSend((Object)scalar, s -> s.getStyle().name());
        q.getAndSend((Object)scalar, Yaml.Scalar::getAnchor, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)scalar, Yaml.Scalar::getTag, t -> this.visit((Tree)t, q));
        q.getAndSend((Object)scalar, Yaml.Scalar::getValue);
        return scalar;
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, RpcSendQueue q) {
        q.getAndSend((Object)sequence, Yaml.Sequence::getOpeningBracketPrefix);
        q.getAndSendList((Object)sequence, Yaml.Sequence::getEntries, e -> e.getId(), e -> this.visit((Tree)e, q));
        q.getAndSend((Object)sequence, Yaml.Sequence::getClosingBracketPrefix);
        q.getAndSend((Object)sequence, Yaml.Sequence::getAnchor, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)sequence, Yaml.Sequence::getTag, t -> this.visit((Tree)t, q));
        return sequence;
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, RpcSendQueue q) {
        q.getAndSend((Object)entry, Yaml.Sequence.Entry::getBlock, b -> this.visit((Tree)b, q));
        q.getAndSend((Object)entry, Yaml.Sequence.Entry::isDash);
        q.getAndSend((Object)entry, Yaml.Sequence.Entry::getTrailingCommaPrefix);
        return entry;
    }

    @Override
    public Yaml visitAnchor(Yaml.Anchor anchor, RpcSendQueue q) {
        q.getAndSend((Object)anchor, Yaml.Anchor::getPostfix);
        q.getAndSend((Object)anchor, Yaml.Anchor::getKey);
        return anchor;
    }

    @Override
    public Yaml visitAlias(Yaml.Alias alias, RpcSendQueue q) {
        q.getAndSend((Object)alias, Yaml.Alias::getAnchor, a -> this.visit((Tree)a, q));
        return alias;
    }

    @Override
    public Yaml visitTag(Yaml.Tag tag, RpcSendQueue q) {
        q.getAndSend((Object)tag, Yaml.Tag::getName);
        q.getAndSend((Object)tag, Yaml.Tag::getSuffix);
        q.getAndSend((Object)tag, t -> t.getKind().name());
        return tag;
    }
}

