/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.TemplateCode;
import org.openrewrite.java.template.internal.UsedMethodDetector;
import org.openrewrite.java.template.processor.RefasterTemplateProcessor;

class TemplateDescriptor {
    private static final ClassValue<java.util.List<String>> LST_TYPE_MAP = new ClassValue<java.util.List<String>>(){

        @Override
        protected java.util.List<String> computeValue(Class<?> type) {
            if (JCTree.JCUnary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Unary");
            }
            if (JCTree.JCBinary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Binary");
            }
            if (JCTree.JCMethodInvocation.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.MethodInvocation");
            }
            if (JCTree.JCFieldAccess.class.isAssignableFrom(type)) {
                return Arrays.asList("J.FieldAccess", "J.Identifier");
            }
            if (JCTree.JCConditional.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Ternary");
            }
            if (JCTree.JCNewClass.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.NewClass");
            }
            if (JCTree.JCLambda.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Lambda");
            }
            if (JCTree.JCExpression.class.isAssignableFrom(type)) {
                return Collections.singletonList("Expression");
            }
            if (JCTree.JCAssert.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Assert");
            }
            if (JCTree.JCStatement.class.isAssignableFrom(type)) {
                return Collections.singletonList("Statement");
            }
            throw new IllegalArgumentException(type.toString());
        }
    };
    private static final Set<Tree.Kind> UNSUPPORTED_STATEMENTS = Stream.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.IF, Tree.Kind.SWITCH, Tree.Kind.WHILE_LOOP).collect(Collectors.toSet());
    private final JavacProcessingEnvironment processingEnv;
    private final JCTree.JCCompilationUnit cu;
    public final JCTree.JCClassDecl classDecl;
    public JCTree.JCMethodDecl method;

    public TemplateDescriptor(JavacProcessingEnvironment processingEnv, JCTree.JCCompilationUnit cu, JCTree.JCClassDecl classDecl, JCTree.JCMethodDecl method) {
        this.classDecl = classDecl;
        this.method = method;
        this.cu = cu;
        this.processingEnv = processingEnv;
    }

    public int getArity() {
        final AtomicReference anyOfCall = new AtomicReference();
        new TreeScanner(){

            @Override
            public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                if (RefasterTemplateProcessor.isAnyOfCall(jcMethodInvocation)) {
                    anyOfCall.set(jcMethodInvocation);
                    return;
                }
                super.visitApply(jcMethodInvocation);
            }
        }.scan(this.method);
        return Optional.ofNullable(anyOfCall.get()).map(call -> call.args.size()).orElse(1);
    }

    public Collection<String> getTypes() {
        if (this.getArity() == 1) {
            JCTree.JCExpression returnExpression = RefasterTemplateProcessor.getReturnExpression(this.method);
            Class<?> clazz = returnExpression != null ? returnExpression.getClass() : ((JCTree.JCStatement)((List)this.method.getBody().getStatements()).last()).getClass();
            return LST_TYPE_MAP.get(clazz);
        }
        final HashSet<String> types = new HashSet<String>();
        new TreeScanner(){

            @Override
            public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                if (RefasterTemplateProcessor.isAnyOfCall(jcMethodInvocation)) {
                    for (JCTree.JCExpression argument : jcMethodInvocation.getArguments()) {
                        types.addAll((Collection)LST_TYPE_MAP.get(argument.getClass()));
                    }
                    return;
                }
                super.visitApply(jcMethodInvocation);
            }
        }.scan(this.method);
        return types;
    }

    public String toJavaTemplateBuilder(int pos) {
        JCTree tree = (JCTree)((List)this.method.getBody().getStatements()).get(0);
        if (tree instanceof JCTree.JCReturn) {
            tree = ((JCTree.JCReturn)tree).getExpression();
        }
        String javaParserClasspathFrom = this.processingEnv.getOptions().get("rewrite.javaParserClasspathFrom");
        boolean classpathFromResources = "resources".equals(javaParserClasspathFrom);
        java.util.List<JCTree.JCTypeParameter> typeParameters = this.classDecl.typarams == null ? Collections.emptyList() : this.classDecl.typarams;
        return TemplateCode.process(tree, this.method.getReturnType().type, this.method.getParameters(), typeParameters, pos, this.method.restype.type instanceof Type.JCVoidType, true, classpathFromResources);
    }

    public boolean validate() {
        if (this.method.typarams != null && !this.method.typarams.isEmpty()) {
            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, "Generic type parameters are only allowed at class level", this.classDecl.sym);
            return false;
        }
        Iterator<JCTree.JCAnnotation> iterator = RefasterTemplateProcessor.getMethodTreeAnnotations(this.method, RefasterTemplateProcessor.UNSUPPORTED_ANNOTATIONS::contains).iterator();
        if (iterator.hasNext()) {
            JCTree.JCAnnotation annotation = iterator.next();
            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, "@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
            return false;
        }
        for (JCTree.JCVariableDecl parameter : this.method.getParameters()) {
            Iterator<JCTree.JCAnnotation> iterator2 = TemplateDescriptor.getVariableTreeAnnotations(parameter, RefasterTemplateProcessor.UNSUPPORTED_ANNOTATIONS::contains).iterator();
            if (!iterator2.hasNext()) continue;
            JCTree.JCAnnotation annotation = iterator2.next();
            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, "@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
            return false;
        }
        if (this.method.body.stats.isEmpty()) {
            return true;
        }
        if (this.method.body.stats.size() > 1) {
            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, "Multiple statements are currently not supported", this.classDecl.sym);
            return false;
        }
        if (UNSUPPORTED_STATEMENTS.contains((Object)this.method.body.stats.get(0).getKind())) {
            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, (Object)((Object)this.method.body.stats.get(0).getKind()) + " statements are currently not supported", this.classDecl.sym);
            return false;
        }
        return new TreeScanner(){
            boolean valid = true;
            int anyOfCount = 0;

            boolean validate(JCTree tree) {
                this.scan(tree);
                return this.valid;
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
                if ("com.google.errorprone.refaster.Refaster".equals(jcFieldAccess.selected.type.tsym.toString()) && "anyOf".equals(jcFieldAccess.name.toString())) {
                    if (++this.anyOfCount > 1) {
                        RefasterTemplateProcessor.printNoteOnce(TemplateDescriptor.this.processingEnv, "Refaster.anyOf() can only be used once per template", TemplateDescriptor.this.classDecl.sym);
                        this.valid = false;
                    }
                    return;
                }
                super.visitSelect(jcFieldAccess);
            }

            @Override
            public void visitIdent(JCTree.JCIdent jcIdent) {
                if (this.valid && jcIdent.sym != null && jcIdent.sym.packge().getQualifiedName().contentEquals("com.google.errorprone.refaster")) {
                    RefasterTemplateProcessor.printNoteOnce(TemplateDescriptor.this.processingEnv, jcIdent.type.tsym.getQualifiedName() + " is currently not supported", TemplateDescriptor.this.classDecl.sym);
                    this.valid = false;
                }
            }
        }.validate(this.method.getBody());
    }

    private static java.util.List<JCTree.JCAnnotation> getVariableTreeAnnotations(VariableTree variableTree, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : variableTree.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    public Collection<Symbol.ClassSymbol> usedTypes(int i) {
        return this.getImports(i).stream().filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).collect(Collectors.toList());
    }

    public Collection<Symbol> usedMembers(int i) {
        return this.getImports(i).stream().filter(sym -> sym instanceof Symbol.VarSymbol || sym instanceof Symbol.MethodSymbol).collect(Collectors.toList());
    }

    private Collection<Symbol> getImports(int i) {
        if (this.getArity() == 1) {
            return ImportDetector.imports(this.method);
        }
        Set<JCTree> skip = this.skipOtherAnyOfArguments(i);
        return ImportDetector.imports(this.method, t -> !skip.contains(t));
    }

    public Collection<Symbol.MethodSymbol> usedMethods(int i) {
        if (this.getArity() == 1) {
            return UsedMethodDetector.usedMethods(this.method, t -> true);
        }
        Set<JCTree> skip = this.skipOtherAnyOfArguments(i);
        return UsedMethodDetector.usedMethods(this.method, t -> !skip.contains(t));
    }

    private Set<JCTree> skipOtherAnyOfArguments(final int i) {
        final HashSet<JCTree> skip = new HashSet<JCTree>();
        new TreeScanner(){

            @Override
            public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                if (RefasterTemplateProcessor.isAnyOfCall(jcMethodInvocation)) {
                    for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                        if (j == i) continue;
                        skip.add(jcMethodInvocation.args.get(j));
                    }
                    return;
                }
                super.visitApply(jcMethodInvocation);
            }
        }.scan(this.method);
        return skip;
    }
}

