/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class FindProperties
extends Recipe {
    private final String displayName = "Find property";
    private final String description = "Finds occurrences of a property key.";
    @Option(displayName="Property key", description="The property key to look for.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    private final @Nullable Boolean relaxedBinding;

    public static Set<Properties.Entry> find(Properties p, final String propertyKey, final @Nullable Boolean relaxedBinding) {
        PropertiesVisitor<Set<Properties.Entry>> findVisitor = new PropertiesVisitor<Set<Properties.Entry>>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, Set<Properties.Entry> ps) {
                if (!Boolean.FALSE.equals(relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)entry.getKey(), (String)propertyKey) : StringUtils.matchesGlob((String)entry.getKey(), (String)propertyKey)) {
                    ps.add(entry);
                }
                return super.visitEntry(entry, ps);
            }
        };
        HashSet<Properties.Entry> ps = new HashSet<Properties.Entry>();
        findVisitor.visit(p, ps);
        return ps;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!Boolean.FALSE.equals(FindProperties.this.relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)entry.getKey(), (String)FindProperties.this.propertyKey) : StringUtils.matchesGlob((String)entry.getKey(), (String)FindProperties.this.propertyKey)) {
                    entry = entry.withValue(entry.getValue().withMarkers(entry.getValue().getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1)));
                }
                return super.visitEntry(entry, ctx);
            }
        };
    }

    @Generated
    public FindProperties(String propertyKey, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public @Nullable Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindProperties(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperties)) {
            return false;
        }
        FindProperties other = (FindProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

