/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Property key", description="The name of the property key whose value is to be changed. Supports glob patterns.", example="management.metrics.binders.*.enabled")
    private final String propertyKey;
    @Option(example="newValue", displayName="New value", description="The new value to be used for key specified by `propertyKey`.")
    private final String newValue;
    @Option(example="oldValue", displayName="Old value", required=false, description="Only change the property value if it matches the configured `oldValue`.")
    private final @Nullable String oldValue;
    @Option(displayName="Regex", description="Default `false`. If enabled, `oldValue` will be interpreted as a Regular Expression, to replace only all parts that match the regex. Capturing group can be used in `newValue`.", required=false)
    private final @Nullable Boolean regex;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    private final @Nullable Boolean relaxedBinding;
    private final String displayName = "Change property value";
    private final String description = "Change a property value leaving the key intact.";

    public Validated validate() {
        return super.validate().and(Validated.test((String)"oldValue", (String)"is required if `regex` is enabled", (Object)this.oldValue, value -> !Boolean.TRUE.equals(this.regex) || !StringUtils.isNullOrEmpty((String)value)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyValueVisitor<ExecutionContext>();
    }

    @Generated
    public ChangePropertyValue(String propertyKey, String newValue, @Nullable String oldValue, @Nullable Boolean regex, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.regex = regex;
        this.relaxedBinding = relaxedBinding;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public @Nullable String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @Generated
    public @Nullable Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePropertyValue(propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", regex=" + this.getRegex() + ", relaxedBinding=" + this.getRelaxedBinding() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public class ChangePropertyValueVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            Properties.Value updatedValue;
            Properties.Entry e = (Properties.Entry)super.visitEntry(entry, p);
            if (this.matchesPropertyKey(e.getKey()) && this.matchesOldValue(e.getValue()) && (updatedValue = this.updateValue(e.getValue())) != null) {
                e = e.withValue(updatedValue);
            }
            return e;
        }

        private @Nullable Properties.Value updateValue(Properties.Value value) {
            Properties.Value updatedValue = value.withText(Boolean.TRUE.equals(ChangePropertyValue.this.regex) ? value.getText().replaceAll(ChangePropertyValue.this.oldValue, ChangePropertyValue.this.newValue) : ChangePropertyValue.this.newValue);
            return updatedValue.getText().equals(value.getText()) ? null : updatedValue;
        }

        private boolean matchesPropertyKey(String prop) {
            return !Boolean.FALSE.equals(ChangePropertyValue.this.relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)prop, (String)ChangePropertyValue.this.propertyKey) : StringUtils.matchesGlob((String)prop, (String)ChangePropertyValue.this.propertyKey);
        }

        private boolean matchesOldValue(Properties.Value value) {
            return StringUtils.isNullOrEmpty((String)ChangePropertyValue.this.oldValue) || (Boolean.TRUE.equals(ChangePropertyValue.this.regex) ? Pattern.compile(ChangePropertyValue.this.oldValue).matcher(value.getText()).find() : value.getText().equals(ChangePropertyValue.this.oldValue));
        }
    }
}

