/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.Arrays;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;

public final class AddPropertyComment
extends Recipe {
    @Option(displayName="Property key", description="The name of the property to add comment.", example="management.metrics.binders")
    private final String propertyKey;
    @Option(example="comment", displayName="Comment", description="The comment to be added.")
    private final String comment;
    @Option(example="true", displayName="Comment out property", description="If true, property will be commented out.", required=false)
    private final @Nullable Boolean commentOutProperty;
    private final String displayName = "Add comment before property key";
    private final String description = "Add a new comment before a property key if not already present, optionally commenting out the property.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        PropertiesVisitor<ExecutionContext> propertiesVisitor = new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext ctx) {
                Properties.File p = file.withContent(ListUtils.flatMap(file.getContent(), (Function)new Function<Properties.Content, Object>(){
                    @Nullable Properties.Content previousContent = null;

                    @Override
                    public Object apply(Properties.Content c) {
                        if (c instanceof Properties.Entry && ((Properties.Entry)c).getKey().equals(AddPropertyComment.this.propertyKey) && !AddPropertyComment.this.isCommentAlreadyPresent(this.previousContent, AddPropertyComment.this.comment)) {
                            Properties.Comment commentContent = new Properties.Comment(Tree.randomId(), this.previousContent == null ? "" : "\n", Markers.EMPTY, Properties.Comment.Delimiter.HASH_TAG, " " + AddPropertyComment.this.comment.trim());
                            this.previousContent = c;
                            return Arrays.asList(commentContent, c.getPrefix().contains("\n") ? c : c.withPrefix("\n" + c.getPrefix()));
                        }
                        this.previousContent = c;
                        return c;
                    }
                }));
                return super.visitFile(p, ctx);
            }

            @Override
            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (Boolean.TRUE.equals(AddPropertyComment.this.commentOutProperty) && entry.getKey().equals(AddPropertyComment.this.propertyKey)) {
                    return new Properties.Comment(Tree.randomId(), entry.getPrefix(), entry.getMarkers(), Properties.Comment.Delimiter.HASH_TAG, " " + entry.printTrimmed(this.getCursor()));
                }
                return super.visitEntry(entry, ctx);
            }
        };
        return Preconditions.check(new FindProperties(this.propertyKey, false).getVisitor(), (TreeVisitor)propertiesVisitor);
    }

    private boolean isCommentAlreadyPresent(@Nullable Properties.Content previousContent, String comment) {
        return previousContent instanceof Properties.Comment && ((Properties.Comment)previousContent).getMessage().contains(comment.trim());
    }

    @Generated
    public AddPropertyComment(String propertyKey, String comment, @Nullable Boolean commentOutProperty) {
        this.propertyKey = propertyKey;
        this.comment = comment;
        this.commentOutProperty = commentOutProperty;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public @Nullable Boolean getCommentOutProperty() {
        return this.commentOutProperty;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPropertyComment(propertyKey=" + this.getPropertyKey() + ", comment=" + this.getComment() + ", commentOutProperty=" + this.getCommentOutProperty() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPropertyComment)) {
            return false;
        }
        AddPropertyComment other = (AddPropertyComment)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$commentOutProperty = this.getCommentOutProperty();
        Boolean other$commentOutProperty = other.getCommentOutProperty();
        if (this$commentOutProperty == null ? other$commentOutProperty != null : !((Object)this$commentOutProperty).equals(other$commentOutProperty)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddPropertyComment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $commentOutProperty = this.getCommentOutProperty();
        result = result * 59 + ($commentOutProperty == null ? 43 : ((Object)$commentOutProperty).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

