/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class RemoteException
extends RuntimeException {
    private final @Nullable String sanitizedStackTrace;
    private final List<String> fixSuggestions;
    private final boolean partialSuccess;

    RemoteException(String message, @Nullable String sanitizedStackTrace, String[] fixSuggestions, boolean partialSuccess) {
        super(message);
        this.sanitizedStackTrace = sanitizedStackTrace;
        this.fixSuggestions = new ArrayList<String>(Arrays.asList(fixSuggestions));
        this.partialSuccess = partialSuccess;
    }

    public static Builder builder(String message, String ... stackTracePrefixFilter) {
        return new Builder(message, stackTracePrefixFilter);
    }

    public static String sanitizeStackTrace(Throwable t, String ... stackTracePrefixFilter) {
        StringJoiner sanitized = new StringJoiner("\n");
        int causeDepth = 0;
        Throwable tt = t;
        while (tt != null) {
            sanitized.add((causeDepth == 0 ? "" : "Caused by ") + tt.getClass().getName() + ": " + tt.getLocalizedMessage());
            RemoteException.sanitizeStackElements(sanitized, tt.getStackTrace(), stackTracePrefixFilter);
            tt = tt.getCause();
            ++causeDepth;
        }
        return sanitized.toString();
    }

    private static void sanitizeStackElements(StringJoiner sanitized, StackTraceElement[] stackTraceElements, String[] stackTracePrefixFilter) {
        StackTraceElement stackTraceElement;
        String stackTraceClass;
        int i = 0;
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        int n = stackTraceElementArray.length;
        for (int j = 0; j < n && !(stackTraceClass = (stackTraceElement = stackTraceElementArray[j]).getClassName()).startsWith("java.util.stream") && !stackTraceClass.startsWith("java.net.Inet"); ++j) {
            for (String filter : stackTracePrefixFilter) {
                if (stackTraceClass.startsWith(filter)) break;
            }
            if (i++ >= 8) {
                sanitized.add("  ...");
                break;
            }
            sanitized.add("  " + stackTraceElement);
        }
    }

    public String encode() {
        Base64.Encoder base64 = Base64.getEncoder();
        StringBuilder builder = new StringBuilder(256);
        builder.append(base64.encodeToString(this.getMessage().getBytes(StandardCharsets.UTF_8))).append('\n');
        if (this.sanitizedStackTrace != null) {
            builder.append(base64.encodeToString(this.sanitizedStackTrace.getBytes(StandardCharsets.UTF_8))).append('\n');
        } else {
            builder.append("null").append('\n');
        }
        if (!this.fixSuggestions.isEmpty()) {
            String suggestions = this.fixSuggestions.stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).map(base64::encodeToString).collect(Collectors.joining(","));
            builder.append(suggestions).append('\n');
        } else {
            builder.append("null").append('\n');
        }
        builder.append(this.partialSuccess);
        return builder.toString();
    }

    public static RemoteException decode(String encoded) {
        Base64.Decoder base64 = Base64.getDecoder();
        String[] lines = encoded.split("\n");
        String message = new String(base64.decode(lines[0]), StandardCharsets.UTF_8);
        String stackTrace = "null".equals(lines[1]) ? null : new String(base64.decode(lines[1]), StandardCharsets.UTF_8);
        String[] suggestions = "null".equals(lines[2]) ? new String[]{} : (String[])Arrays.stream(lines[2].split(",")).map(s -> new String(base64.decode((String)s), StandardCharsets.UTF_8)).toArray(String[]::new);
        boolean partialSuccess = lines.length > 3 ? Boolean.parseBoolean(lines[3]) : false;
        return new RemoteException(message, stackTrace, suggestions, partialSuccess);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(this);
        if (this.sanitizedStackTrace != null) {
            s.println(this.sanitizedStackTrace);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteException that = (RemoteException)o;
        return Objects.equals(this.sanitizedStackTrace, that.sanitizedStackTrace) && Objects.equals(this.fixSuggestions, that.fixSuggestions);
    }

    public int hashCode() {
        int result = Objects.hash(this.sanitizedStackTrace);
        return 31 * result + Objects.hashCode(this.fixSuggestions);
    }

    @Generated
    public @Nullable String getSanitizedStackTrace() {
        return this.sanitizedStackTrace;
    }

    @Generated
    public List<String> getFixSuggestions() {
        return this.fixSuggestions;
    }

    @Generated
    public boolean isPartialSuccess() {
        return this.partialSuccess;
    }

    public static class Builder {
        private final String message;
        private final List<String> fixSuggestions = new ArrayList<String>();
        private String sanitizedStackTrace;
        private boolean partialSuccess;

        public Builder(String message, String ... stackTracePrefixFilter) {
            this.message = message;
            StringJoiner sanitized = new StringJoiner("\n");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement[] shortenedStackTrace = new StackTraceElement[stackTrace.length - 3];
            System.arraycopy(stackTrace, 3, shortenedStackTrace, 0, stackTrace.length - 3);
            RemoteException.sanitizeStackElements(sanitized, shortenedStackTrace, stackTracePrefixFilter);
            this.sanitizedStackTrace = sanitized.toString();
        }

        public Builder cause(Throwable t, String ... stackTracePrefixFilter) {
            this.sanitizedStackTrace = RemoteException.sanitizeStackTrace(t, stackTracePrefixFilter);
            return this;
        }

        public Builder fixSuggestions(String ... fixSuggestions) {
            return this.fixSuggestions(Arrays.asList(fixSuggestions));
        }

        public Builder fixSuggestions(List<String> fixSuggestions) {
            this.fixSuggestions.addAll(fixSuggestions);
            return this;
        }

        public Builder partialSuccess(boolean partialSuccess) {
            this.partialSuccess = partialSuccess;
            return this;
        }

        public RemoteException build() {
            return new RemoteException(this.message, this.sanitizedStackTrace, this.fixSuggestions.toArray(new String[0]), this.partialSuccess);
        }
    }
}

