/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import org.jspecify.annotations.Nullable;

public enum Scope {
    None,
    Compile,
    Provided,
    Runtime,
    Test,
    System,
    Import,
    Invalid;


    public boolean isInClasspathOf(@Nullable Scope scope) {
        return this.transitiveOf(scope) != null;
    }

    public @Nullable Scope transitiveOf(@Nullable Scope scope) {
        if (scope == null) {
            return this;
        }
        switch (scope.ordinal()) {
            case 0: {
                return this;
            }
            case 1: {
                switch (this.ordinal()) {
                    case 1: {
                        return Compile;
                    }
                    case 3: {
                        return Runtime;
                    }
                }
                return null;
            }
            case 2: {
                switch (this.ordinal()) {
                    case 1: 
                    case 3: {
                        return Provided;
                    }
                }
                return null;
            }
            case 3: {
                switch (this.ordinal()) {
                    case 1: 
                    case 3: {
                        return Runtime;
                    }
                }
                return null;
            }
            case 4: {
                switch (this.ordinal()) {
                    case 1: 
                    case 3: {
                        return Test;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static Scope fromName(@Nullable String scope) {
        if (scope == null) {
            return Compile;
        }
        switch (scope.toLowerCase()) {
            case "compile": {
                return Compile;
            }
            case "provided": {
                return Provided;
            }
            case "runtime": {
                return Runtime;
            }
            case "test": {
                return Test;
            }
            case "system": {
                return System;
            }
            case "import": {
                return Import;
            }
        }
        return Invalid;
    }

    public static @Nullable Scope maxPrecedence(@Nullable Scope scope1, @Nullable Scope scope2) {
        if (scope1 == null) {
            return scope2;
        }
        if (scope2 == null) {
            return scope1;
        }
        if (scope1.ordinal() <= scope2.ordinal()) {
            return scope1;
        }
        return scope2;
    }

    @Deprecated
    public static @Nullable String asGradleConfigurationName(@Nullable Scope scope) {
        return Scope.asConsumableGradleConfigurationName(scope);
    }

    public static @Nullable String asConsumableGradleConfigurationName(@Nullable Scope scope) {
        if (scope == null) {
            return null;
        }
        switch (scope.ordinal()) {
            case 1: {
                return "implementation";
            }
            case 2: {
                return "compileOnly";
            }
            case 3: {
                return "runtimeOnly";
            }
            case 4: {
                return "testImplementation";
            }
            case 5: {
                return "system";
            }
        }
        return null;
    }

    public static @Nullable String asResolvableGradleConfigurationName(@Nullable Scope scope) {
        if (scope == null) {
            return null;
        }
        switch (scope.ordinal()) {
            case 1: {
                return "compileClasspath";
            }
            case 2: {
                return "compileOnly";
            }
            case 3: {
                return "runtimeClasspath";
            }
            case 4: {
                return "testRuntimeClasspath";
            }
            case 5: {
                return "system";
            }
        }
        return null;
    }
}

