/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

public class FindScm
extends Recipe {
    final String displayName = "Find SCM tag";
    final String description = "Finds any `<scm>` tag directly inside the `<project>` root of a Maven pom.xml file.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if ("project".equals(tag.getName())) {
                    return super.visitTag(tag, (Object)ctx);
                }
                if ("scm".equals(tag.getName())) {
                    return (Xml)SearchResult.found((Tree)tag);
                }
                return tag;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

