/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class FindManagedDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="3.0.0", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private final String displayName = "Find Maven dependency management entry";
    private final String description = "Finds first-order dependency management entries, i.e. dependencies that are defined directly in a project.";

    public static Set<Xml.Tag> find(Xml.Document maven, String groupId, String artifactId) {
        return FindManagedDependency.find(maven, groupId, artifactId, null, null);
    }

    public static Set<Xml.Tag> find(Xml.Document maven, final String groupId, final String artifactId, final @Nullable String version, final @Nullable String versionPattern) {
        final HashSet<Xml.Tag> ds = new HashSet<Xml.Tag>();
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isManagedDependencyTag(groupId, artifactId) && FindManagedDependency.versionIsValid(version, versionPattern, () -> this.findManagedDependency(tag, null))) {
                    ds.add(tag);
                }
                return super.visitTag(tag, ctx);
            }
        }.visit((Tree)maven, new InMemoryExecutionContext());
        return ds;
    }

    public String getInstanceNameSuffix() {
        String maybeVersionSuffix = this.version == null ? "" : String.format(":%s%s", this.version, this.versionPattern == null ? "" : this.versionPattern);
        return String.format("`%s:%s%s`", this.groupId, this.artifactId, maybeVersionSuffix);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isManagedDependencyTag(FindManagedDependency.this.groupId, FindManagedDependency.this.artifactId) && FindManagedDependency.versionIsValid(FindManagedDependency.this.version, FindManagedDependency.this.versionPattern, () -> this.findManagedDependency(tag, null))) {
                    return (Xml.Tag)SearchResult.found((Tree)tag);
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    private static boolean versionIsValid(@Nullable String desiredVersion, @Nullable String versionPattern, Supplier<@Nullable ResolvedManagedDependency> resolvedDependencySupplier) {
        if (desiredVersion == null) {
            return true;
        }
        ResolvedManagedDependency resolvedDependency = resolvedDependencySupplier.get();
        if (resolvedDependency == null) {
            return false;
        }
        String actualVersion = resolvedDependency.getVersion();
        Validated validate = Semver.validate((String)desiredVersion, (String)versionPattern);
        return actualVersion != null && validate.isValid() && validate.getValue() != null && ((VersionComparator)validate.getValue()).isValid(actualVersion, actualVersion);
    }

    @Generated
    public FindManagedDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindManagedDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindManagedDependency)) {
            return false;
        }
        FindManagedDependency other = (FindManagedDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindManagedDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

