/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.search.EffectiveMavenRepositoriesTable;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

public final class EffectiveMavenRepositories
extends Recipe {
    private final String displayName = "List effective Maven repositories";
    private final String description = "Lists the Maven repositories that would be used for dependency resolution, in order of precedence. This includes Maven repositories defined in the Maven settings file (and those contributed by active profiles) as determined when the LST was produced.";
    @Option(displayName="Use markers", description="Whether to add markers for each effective Maven repository to the POM. Default `false`.", required=false)
    private final @Nullable Boolean useMarkers;
    private final transient EffectiveMavenRepositoriesTable table = new EffectiveMavenRepositoriesTable(this);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
                MavenSettings settings = mctx.effectiveSettings(mrr);
                StringJoiner repositories = new StringJoiner("\n");
                if (settings == null) {
                    for (MavenRepository repository2 : mrr.getPom().getRepositories()) {
                        repositories.add(repository2.getUri());
                        EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), repository2.getUri()));
                    }
                    repositories.add(MavenRepository.MAVEN_CENTRAL.getUri());
                    EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), MavenRepository.MAVEN_CENTRAL.getUri()));
                } else {
                    Collection<MavenRepositoryMirror> mirrors = mctx.getMirrors(settings);
                    List effectiveRepositories = Stream.concat(settings.getActiveRepositories(settings.getActiveProfiles() == null ? Collections.emptyList() : settings.getActiveProfiles().getActiveProfiles()).stream().map(rawRepo -> MavenRepository.builder().uri(rawRepo.getUrl()).build()), Stream.concat(mrr.getPom().getRepositories().stream(), Stream.of(MavenRepository.MAVEN_CENTRAL))).map(repository -> MavenRepositoryMirror.apply(mirrors, repository)).collect(Collectors.toList());
                    for (MavenRepository repository3 : effectiveRepositories) {
                        repositories.add(repository3.getUri());
                        EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), repository3.getUri()));
                    }
                }
                if (Boolean.TRUE.equals(EffectiveMavenRepositories.this.useMarkers)) {
                    return (Xml.Document)SearchResult.found((Tree)document, (String)repositories.toString());
                }
                return document;
            }
        };
    }

    @Generated
    public EffectiveMavenRepositories(@Nullable Boolean useMarkers) {
        this.useMarkers = useMarkers;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public @Nullable Boolean getUseMarkers() {
        return this.useMarkers;
    }

    @Generated
    public EffectiveMavenRepositoriesTable getTable() {
        return this.table;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EffectiveMavenRepositories(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", useMarkers=" + this.getUseMarkers() + ", table=" + (Object)((Object)this.getTable()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveMavenRepositories)) {
            return false;
        }
        EffectiveMavenRepositories other = (EffectiveMavenRepositories)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useMarkers = this.getUseMarkers();
        Boolean other$useMarkers = other.getUseMarkers();
        if (this$useMarkers == null ? other$useMarkers != null : !((Object)this$useMarkers).equals(other$useMarkers)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof EffectiveMavenRepositories;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useMarkers = this.getUseMarkers();
        result = result * 59 + ($useMarkers == null ? 43 : ((Object)$useMarkers).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

