/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.search.DependencyInsight;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.Semver;

public final class DoesNotIncludeDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used. All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Only direct dependencies", description="Default false. If enabled, transitive dependencies will not be considered.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;
    @Option(displayName="Scope", description="Default any. If specified, only the requested scope's classpaths will be checked.", required=false, valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final @Nullable String scope;
    private final String displayName = "Does not include Maven dependency";
    private final String description = "A precondition which returns false if visiting a Maven pom which includes the specified dependency in the classpath of some scope. For compatibility with multimodule projects, this should most often be applied as a precondition.";

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"groupId", (String)this.groupId).and(Validated.notBlank((String)"artifactId", (String)this.artifactId))).and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid));
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> di;
            {
                this.di = new DependencyInsight(DoesNotIncludeDependency.this.groupId, DoesNotIncludeDependency.this.artifactId, DoesNotIncludeDependency.this.scope, DoesNotIncludeDependency.this.version, DoesNotIncludeDependency.this.onlyDirect).getVisitor();
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return this.di.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t2 = this.di.visit(tree, (Object)ctx);
                if (t2 == tree) {
                    return SearchResult.found((Tree)tree);
                }
                return tree;
            }
        };
    }

    @Generated
    public DoesNotIncludeDependency(String groupId, String artifactId, @Nullable String version, @Nullable Boolean onlyDirect, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.onlyDirect = onlyDirect;
        this.scope = scope;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DoesNotIncludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", onlyDirect=" + this.getOnlyDirect() + ", scope=" + this.getScope() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotIncludeDependency)) {
            return false;
        }
        DoesNotIncludeDependency other = (DoesNotIncludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DoesNotIncludeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

