/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeClassLoaderFactory;
import org.openrewrite.marketplace.ThrowingRecipeBundleReader;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.marketplace.MavenRecipeBundleReader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;

public class MavenRecipeBundleResolver
implements RecipeBundleResolver {
    private final ExecutionContext ctx;
    private final MavenArtifactDownloader downloader;
    private final RecipeClassLoaderFactory classLoaderFactory;
    private transient @Nullable MavenRecipeBundleReader reader;

    public MavenRecipeBundleResolver(ExecutionContext ctx, MavenArtifactDownloader downloader, RecipeClassLoaderFactory classLoaderFactory) {
        this.ctx = ctx;
        this.downloader = downloader;
        this.classLoaderFactory = classLoaderFactory;
    }

    public String getEcosystem() {
        return "maven";
    }

    public RecipeBundleReader resolve(RecipeBundle bundle) {
        if (this.reader == null) {
            if (StringUtils.isBlank((CharSequence)bundle.getVersion())) {
                return new ThrowingRecipeBundleReader(bundle, (RuntimeException)new IllegalStateException("Unable to read a Maven recipe bundle that has no version"));
            }
            String[] ga = bundle.getPackageName().split(":");
            GroupArtifactVersion gav = new GroupArtifactVersion(ga[0], ga[1], bundle.getVersion());
            return this.resolveDependencies(gav).map(mrr -> {
                ResolvedDependency resolvedDependency = mrr.getDependencies().get((Object)Scope.Runtime).stream().filter(ResolvedDependency::isDirect).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find direct dependency for " + gav));
                bundle.setVersion(resolvedDependency.getDatedSnapshotVersion() == null ? resolvedDependency.getVersion() : resolvedDependency.getDatedSnapshotVersion());
                this.reader = new MavenRecipeBundleReader(bundle, (MavenResolutionResult)mrr, this.downloader, this.classLoaderFactory);
                return this.reader;
            }).orElseGet(() -> new ThrowingRecipeBundleReader(bundle, (RuntimeException)new IllegalStateException("Unable to resolve recipe " + gav)));
        }
        return this.reader;
    }

    private Optional<MavenResolutionResult> resolveDependencies(GroupArtifactVersion gav) {
        String pomXml = "<project>    <groupId>io.moderne</groupId>    <artifactId>recipe-downloader</artifactId>    <version>1</version>    <dependencies>        <dependency>            <groupId>" + gav.getGroupId() + "</groupId>            <artifactId>" + gav.getArtifactId() + "</artifactId>            <version>" + gav.getVersion() + "</version>        </dependency>    </dependencies></project>";
        return MavenParser.builder().build().parse(this.ctx, pomXml).findFirst().flatMap(sf -> sf.getMarkers().findFirst(MavenResolutionResult.class)).filter(mrr -> !mrr.getDependencies().isEmpty());
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

