/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.UpgradePluginVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.tree.Xml;

public class ExplicitPluginVersion
extends Recipe {
    final String displayName = "Add explicit plugin versions";
    final String description = "Add explicit plugin versions to POMs for reproducibility, as [MNG-4173](https://issues.apache.org/jira/browse/MNG-4173) removes automatic version resolution for POM plugins.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag() && !t.getChild("version").isPresent()) {
                    ResolvedPom resolvedPom = this.getResolutionResult().getPom();
                    String groupId = resolvedPom.getValue(tag.getChildValue("groupId").orElse("org.apache.maven.plugins"));
                    String artifactId = resolvedPom.getValue(tag.getChildValue("artifactId").orElse("*"));
                    if (resolvedPom.getPluginManagement().stream().noneMatch(p -> groupId.equals(p.getGroupId()) && StringUtils.matchesGlob((String)p.getArtifactId(), (String)artifactId))) {
                        this.doAfterVisit(new UpgradePluginVersion(groupId, artifactId, "latest.release", null, true, true).getVisitor());
                    }
                }
                return t;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

