/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import java.util.Comparator;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ExplicitPluginGroupId
extends Recipe {
    private final String displayName = "Add explicit `groupId` to Maven plugins";
    private final String description = "Add the default `<groupId>org.apache.maven.plugins</groupId>` to plugins for clarity.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag() && !t.getChild("groupId").isPresent() && t.getChild("artifactId").isPresent()) {
                    Xml.Tag groupIdTag = Xml.Tag.build((String)"<groupId>org.apache.maven.plugins</groupId>");
                    t = (Xml.Tag)new AddToTagVisitor(t, groupIdTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.maybeUpdateModel();
                }
                return t;
            }
        };
    }

    @Generated
    public ExplicitPluginGroupId() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ExplicitPluginGroupId(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitPluginGroupId)) {
            return false;
        }
        ExplicitPluginGroupId other = (ExplicitPluginGroupId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExplicitPluginGroupId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

