/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class DependencyManagementDependencyRequiresVersion
extends Recipe {
    final String displayName = "Dependency management dependencies should have a version";
    final String description = "If they don't have a version, they can't possibly affect dependency resolution anywhere, and can be safely removed.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isManagedDependencyTag() && tag.getChildValue("version").orElse(null) == null) {
                    this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true, true));
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

