/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.ChangeParentPom;
import org.openrewrite.semver.Semver;

public final class UpgradeParentVersion
extends ScanningRecipe<ChangeParentPom.Accumulator> {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="org.springframework.boot")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="spring-boot-parent")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Only external", description="Only upgrade `<parent>` if external to the project, i.e. it has an empty `<relativePath>`. Defaults to `false`.", required=false)
    private final @Nullable Boolean onlyExternal;
    private final String displayName = "Upgrade Maven parent project version";
    private final String description = "Set the parent pom version number according to a [version selector](https://docs.openrewrite.org/reference/dependency-version-selectors) or to a specific version number.";

    public String getInstanceNameSuffix() {
        return String.format("to `%s:%s:%s`", this.groupId, this.artifactId, this.newVersion);
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    private ChangeParentPom getChangeParentPom() {
        return new ChangeParentPom(this.groupId, null, this.artifactId, null, this.newVersion, Boolean.TRUE.equals(this.onlyExternal) ? "" : null, null, this.versionPattern, false, null);
    }

    public ChangeParentPom.Accumulator getInitialValue(ExecutionContext ctx) {
        return this.getChangeParentPom().getInitialValue(ctx);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(ChangeParentPom.Accumulator acc) {
        return this.getChangeParentPom().getScanner(acc);
    }

    public Collection<? extends SourceFile> generate(ChangeParentPom.Accumulator acc, ExecutionContext ctx) {
        return this.getChangeParentPom().generate(acc, ctx);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(ChangeParentPom.Accumulator acc) {
        return this.getChangeParentPom().getVisitor(acc);
    }

    @Generated
    public UpgradeParentVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean onlyExternal) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.onlyExternal = onlyExternal;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOnlyExternal() {
        return this.onlyExternal;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeParentVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", onlyExternal=" + this.getOnlyExternal() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeParentVersion)) {
            return false;
        }
        UpgradeParentVersion other = (UpgradeParentVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyExternal = this.getOnlyExternal();
        Boolean other$onlyExternal = other.getOnlyExternal();
        if (this$onlyExternal == null ? other$onlyExternal != null : !((Object)this$onlyExternal).equals(other$onlyExternal)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeParentVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyExternal = this.getOnlyExternal();
        result = result * 59 + ($onlyExternal == null ? 43 : ((Object)$onlyExternal).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

