/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddProperty;
import org.openrewrite.maven.AddPropertyVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpdateMavenProjectPropertyJavaVersion
extends Recipe {
    private static final List<String> JAVA_VERSION_PROPERTIES = Arrays.asList("java.version", "jdk.version", "javaVersion", "jdkVersion", "maven.compiler.source", "maven.compiler.target", "maven.compiler.release", "release.version");
    private static final List<XPathMatcher> JAVA_VERSION_XPATH_MATCHERS = JAVA_VERSION_PROPERTIES.stream().map(property -> "/project/properties/" + property).map(XPathMatcher::new).collect(Collectors.toList());
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    private final String displayName = "Update Maven Java project properties";
    private final String description = "The Java version is determined by several project properties, including:\n\n * `java.version`\n * `jdk.version`\n * `javaVersion`\n * `jdkVersion`\n * `maven.compiler.source`\n * `maven.compiler.target`\n * `maven.compiler.release`\n * `release.version`\n\nIf none of these properties are in use and the maven compiler plugin is not otherwise configured, adds the `maven.compiler.release` property.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            boolean compilerPluginConfiguredExplicitly;

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (this.getResolutionResult().parentPomIsProjectPom()) {
                    for (Plugin plugin : Optional.ofNullable(this.getResolutionResult().getParent()).map(MavenResolutionResult::getPom).map(ResolvedPom::getPlugins).orElse(Collections.emptyList())) {
                        if (!"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-compiler-plugin".equals(plugin.getArtifactId()) || plugin.getConfiguration() == null) continue;
                        for (String property : JAVA_VERSION_PROPERTIES) {
                            if (this.getResolutionResult().getPom().getRequested().getProperties().get(property) == null) continue;
                            try {
                                float parsed = Float.parseFloat(this.getResolutionResult().getPom().getProperties().get(property));
                                if (!(parsed < (float)UpdateMavenProjectPropertyJavaVersion.this.version.intValue()) || !(plugin.getConfiguration().get("source") != null && plugin.getConfiguration().get("source").textValue().contains(property) || plugin.getConfiguration().get("target") != null && plugin.getConfiguration().get("target").textValue().contains(property)) && (plugin.getConfiguration().get("release") == null || !plugin.getConfiguration().get("release").textValue().contains(property))) continue;
                                d = (Xml.Document)new AddPropertyVisitor(property, String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version), null).visitNonNull((Tree)d, ctx);
                                this.maybeUpdateModel();
                            }
                            catch (NumberFormatException parsed) {}
                        }
                    }
                    return d;
                }
                Map<String, String> currentProperties = this.getResolutionResult().getPom().getProperties();
                boolean foundProperty = false;
                for (String property : JAVA_VERSION_PROPERTIES) {
                    String propertyValue = currentProperties.get(property);
                    if (propertyValue == null) continue;
                    foundProperty = true;
                    try {
                        if (!(Float.parseFloat(propertyValue) < (float)UpdateMavenProjectPropertyJavaVersion.this.version.intValue())) continue;
                        d = (Xml.Document)new AddProperty(property, String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version), null, false).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                        this.maybeUpdateModel();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (!foundProperty && UpdateMavenProjectPropertyJavaVersion.this.version >= 9 && !this.compilerPluginConfiguredExplicitly) {
                    d = (Xml.Document)new AddProperty("maven.compiler.release", String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version), null, false).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                    this.maybeUpdateModel();
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin")) {
                    t.getChild("configuration").ifPresent(compilerPluginConfig -> {
                        if (compilerPluginConfig.getChildValue("source").isPresent() || compilerPluginConfig.getChildValue("target").isPresent() || compilerPluginConfig.getChildValue("release").isPresent()) {
                            this.compilerPluginConfiguredExplicitly = true;
                        }
                    });
                }
                return t;
            }
        };
    }

    @Generated
    public UpdateMavenProjectPropertyJavaVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateMavenProjectPropertyJavaVersion(version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMavenProjectPropertyJavaVersion)) {
            return false;
        }
        UpdateMavenProjectPropertyJavaVersion other = (UpdateMavenProjectPropertyJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMavenProjectPropertyJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

