/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RenamePropertyKey
extends Recipe {
    @Option(displayName="Old key", description="The old name of the property key to be replaced.", example="junit.version")
    private final String oldKey;
    @Option(displayName="New key", description="The new property name to use.", example="version.org.junit")
    private final String newKey;
    private final String displayName = "Rename Maven property key";
    private final String description = "Rename the specified Maven project property key leaving the value unchanged.";

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKey, this.newKey);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final String oldKeyAsProperty;
            final String newKeyAsProperty;
            {
                this.oldKeyAsProperty = "${" + RenamePropertyKey.this.oldKey + "}";
                this.newKeyAsProperty = "${" + RenamePropertyKey.this.newKey + "}";
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional value;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isPropertyTag() && RenamePropertyKey.this.oldKey.equals(t.getName())) {
                    t = t.withName(RenamePropertyKey.this.newKey);
                }
                if (t.getChildren().isEmpty() && (value = t.getValue()).isPresent() && ((String)value.get()).contains(this.oldKeyAsProperty)) {
                    String newValue = ((String)value.get()).replace(this.oldKeyAsProperty, this.newKeyAsProperty);
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(t, newValue));
                }
                return t;
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (d != document) {
                    this.maybeUpdateModel();
                }
                return d;
            }
        };
    }

    @Generated
    public RenamePropertyKey(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    @Generated
    public String getOldKey() {
        return this.oldKey;
    }

    @Generated
    public String getNewKey() {
        return this.newKey;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RenamePropertyKey(oldKey=" + this.getOldKey() + ", newKey=" + this.getNewKey() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenamePropertyKey)) {
            return false;
        }
        RenamePropertyKey other = (RenamePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKey = this.getOldKey();
        String other$oldKey = other.getOldKey();
        if (this$oldKey == null ? other$oldKey != null : !this$oldKey.equals(other$oldKey)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        if (this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenamePropertyKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKey = this.getOldKey();
        result = result * 59 + ($oldKey == null ? 43 : $oldKey.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

