/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantProperties
extends Recipe {
    @Option(displayName="Property name", description="Property name glob expression pattern used to match properties that should be checked.", example="*.version", required=false)
    private final @Nullable String namePattern;
    @Option(displayName="Only if values match", description="Only remove the property if its value exactly matches the property value in the parent pom. Default `false`.", required=false)
    private final @Nullable Boolean onlyIfValuesMatch;
    private final String displayName = "Remove redundant properties";
    private final String description = "Remove properties when a parent POM specifies the same property.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isMatchingPropertyTag(tag) && this.hasMatchingValue(tag, ctx)) {
                    this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true, true));
                    this.maybeUpdateModel();
                }
                return t;
            }

            private boolean isMatchingPropertyTag(Xml.Tag tag) {
                return this.isPropertyTag() && (StringUtils.isNullOrEmpty((String)RemoveRedundantProperties.this.namePattern) || StringUtils.matchesGlob((String)tag.getName(), (String)RemoveRedundantProperties.this.namePattern));
            }

            private boolean hasMatchingValue(Xml.Tag tag, ExecutionContext ctx) {
                String parentPropertyValue;
                Map<String, String> parentProperties;
                MavenResolutionResult mrr = this.getResolutionResult();
                if (mrr.getParent() == null) {
                    MavenPomDownloader downloader = new MavenPomDownloader(mrr.getProjectPoms(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles());
                    try {
                        parentProperties = mrr.getPom().getRequested().withProperties(Collections.emptyMap()).withDependencies(Collections.emptyList()).withDependencyManagement(Collections.emptyList()).withPlugins(Collections.emptyList()).withPluginManagement(Collections.emptyList()).resolve(mrr.getActiveProfiles(), downloader, ctx).getProperties();
                    }
                    catch (MavenDownloadingException e) {
                        return false;
                    }
                } else {
                    parentProperties = mrr.getParent().getPom().getProperties();
                }
                if ((parentPropertyValue = parentProperties.get(tag.getName())) == null) {
                    return false;
                }
                if (!Boolean.TRUE.equals(RemoveRedundantProperties.this.onlyIfValuesMatch)) {
                    return true;
                }
                return tag.getValue().map(parentPropertyValue::equals).orElse(false);
            }
        };
    }

    @Generated
    public RemoveRedundantProperties(@Nullable String namePattern, @Nullable Boolean onlyIfValuesMatch) {
        this.namePattern = namePattern;
        this.onlyIfValuesMatch = onlyIfValuesMatch;
    }

    @Generated
    public @Nullable String getNamePattern() {
        return this.namePattern;
    }

    @Generated
    public @Nullable Boolean getOnlyIfValuesMatch() {
        return this.onlyIfValuesMatch;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantProperties(namePattern=" + this.getNamePattern() + ", onlyIfValuesMatch=" + this.getOnlyIfValuesMatch() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantProperties)) {
            return false;
        }
        RemoveRedundantProperties other = (RemoveRedundantProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyIfValuesMatch = this.getOnlyIfValuesMatch();
        Boolean other$onlyIfValuesMatch = other.getOnlyIfValuesMatch();
        if (this$onlyIfValuesMatch == null ? other$onlyIfValuesMatch != null : !((Object)this$onlyIfValuesMatch).equals(other$onlyIfValuesMatch)) {
            return false;
        }
        String this$namePattern = this.getNamePattern();
        String other$namePattern = other.getNamePattern();
        if (this$namePattern == null ? other$namePattern != null : !this$namePattern.equals(other$namePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyIfValuesMatch = this.getOnlyIfValuesMatch();
        result = result * 59 + ($onlyIfValuesMatch == null ? 43 : ((Object)$onlyIfValuesMatch).hashCode());
        String $namePattern = this.getNamePattern();
        result = result * 59 + ($namePattern == null ? 43 : $namePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

