/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RemovePluginDependency
extends Recipe {
    private static final XPathMatcher PLUGIN_WITH_DEPENDENCIES_MATCHER = new XPathMatcher("/project/build/plugins/plugin[dependencies]");
    @Option(displayName="Plugin group ID", description="Group ID of the plugin from which the dependency will be removed. Supports glob.A Group ID is the first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String pluginGroupId;
    @Option(displayName="Plugin artifact ID", description="Artifact ID of the plugin from which the dependency will be removed. Supports glob.The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String pluginArtifactId;
    @Option(displayName="Group", description="The first part of a plugin dependency coordinate. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a plugin dependency coordinate. Supports glob.", example="guava")
    private final String artifactId;
    private final String displayName = "Remove Maven plugin dependency";
    private final String description = "Removes a dependency from the <dependencies> section of a plugin in the pom.xml.";

    public String getInstanceNameSuffix() {
        return String.format("from `%s:%s`", this.pluginGroupId, this.pluginArtifactId);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveDependencyVisitor();
    }

    @Generated
    public RemovePluginDependency(String pluginGroupId, String pluginArtifactId, String groupId, String artifactId) {
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    @Generated
    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemovePluginDependency(pluginGroupId=" + this.getPluginGroupId() + ", pluginArtifactId=" + this.getPluginArtifactId() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemovePluginDependency)) {
            return false;
        }
        RemovePluginDependency other = (RemovePluginDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginGroupId = this.getPluginGroupId();
        String other$pluginGroupId = other.getPluginGroupId();
        if (this$pluginGroupId == null ? other$pluginGroupId != null : !this$pluginGroupId.equals(other$pluginGroupId)) {
            return false;
        }
        String this$pluginArtifactId = this.getPluginArtifactId();
        String other$pluginArtifactId = other.getPluginArtifactId();
        if (this$pluginArtifactId == null ? other$pluginArtifactId != null : !this$pluginArtifactId.equals(other$pluginArtifactId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemovePluginDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginGroupId = this.getPluginGroupId();
        result = result * 59 + ($pluginGroupId == null ? 43 : $pluginGroupId.hashCode());
        String $pluginArtifactId = this.getPluginArtifactId();
        result = result * 59 + ($pluginArtifactId == null ? 43 : $pluginArtifactId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private class RemoveDependencyVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private RemoveDependencyVisitor() {
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag plugin = super.visitTag(tag, ctx);
            if (!PLUGIN_WITH_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                return plugin;
            }
            if (!this.childValueMatches(plugin, "groupId", RemovePluginDependency.this.pluginGroupId) || !this.childValueMatches(plugin, "artifactId", RemovePluginDependency.this.pluginArtifactId)) {
                return plugin;
            }
            Xml.Tag dependencies = (Xml.Tag)plugin.getChild("dependencies").get();
            Xml.Tag updatedDependencies = (Xml.Tag)(plugin = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)plugin, (Xml.Tag)dependencies, dependencyTag -> !this.childValueMatches((Xml.Tag)dependencyTag, "groupId", RemovePluginDependency.this.groupId) || !this.childValueMatches((Xml.Tag)dependencyTag, "artifactId", RemovePluginDependency.this.artifactId))).getChild("dependencies").get();
            if (updatedDependencies.getChildren().isEmpty()) {
                plugin = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)plugin, (Xml.Tag)plugin, pluginChildTag -> !"dependencies".equals(pluginChildTag.getName()));
            }
            return plugin;
        }

        private boolean childValueMatches(Xml.Tag tag, String childValueName, String globPattern) {
            return tag.getChildValue(childValueName).map(it -> StringUtils.matchesGlob((String)it, (String)globPattern)).orElse(false);
        }
    }
}

