/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class ModernizeObsoletePoms
extends Recipe {
    final String displayName = "Modernize obsolete Maven poms";
    final String description = "Very old Maven poms are no longer supported by current versions of Maven. This recipe updates poms with `<pomVersion>3</pomVersion>` to `<modelVersion>4.0.0</modelVersion>` of the Maven pom schema. This does not attempt to upgrade old dependencies or plugins and is best regarded as the starting point of a migration rather than an end-point.";
    private static final XPathMatcher POM_VERSION = new XPathMatcher("/project/pomVersion");
    private static final XPathMatcher CURRENT_VERSION = new XPathMatcher("/project/currentVersion");
    private static final XPathMatcher LOGO = new XPathMatcher("/project/organization/logo");
    private static final XPathMatcher UNIT_TEST = new XPathMatcher("/project/build/unitTest");
    private static final XPathMatcher REPOSITORY = new XPathMatcher("/project/repository");
    private static final XPathMatcher ISSUE_TRACKING_URL = new XPathMatcher("/project/issueTrackingUrl");
    private static final XPathMatcher PACKAGE = new XPathMatcher("/project/package");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/pom.xml"), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                Cursor c = this.getCursor();
                if (POM_VERSION.matches(c)) {
                    return t.withName("modelVersion").withValue("4.0.0");
                }
                if (CURRENT_VERSION.matches(c)) {
                    return t.withName("version");
                }
                if (REPOSITORY.matches(c)) {
                    if (!t.getChildValue("url").isPresent()) return null;
                    return (Xml.Tag)this.autoFormat((Xml)Xml.Tag.build((String)("<repositories>\n    <repository>\n        <id>repo</id>\n        <url>" + (String)t.getChildValue("url").get() + "</url>\n    </repository>\n</repositories>\n")), ctx, c.getParentTreeCursor());
                }
                if (ISSUE_TRACKING_URL.matches(c)) {
                    if (!t.getValue().isPresent()) return null;
                    return (Xml.Tag)this.autoFormat((Xml)Xml.Tag.build((String)("<issueManagement>\n    <system>IssueTracker</system>\n    <url>" + (String)t.getValue().get() + "</url>\n</issueManagement>\n")), ctx, c.getParentTreeCursor());
                }
                if (LOGO.matches(c)) return null;
                if (UNIT_TEST.matches(c)) return null;
                if (!PACKAGE.matches(c)) return t;
                return null;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

