/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.UpdateMavenModel;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ExcludeDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava")
    private final String artifactId;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If you specify `compile`, this will NOT match dependencies in `runtime`. The purpose of this is to be able to exclude dependencies that should be in a higher scope, e.g. a compile dependency that should be a test dependency.", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    private final @Nullable String scope;
    private final String displayName = "Exclude Maven dependency";
    private final String description = "Exclude specified dependency from any dependency that transitively includes it.";

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                if (s != null) {
                    Scope.fromName(s);
                }
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Repeat.repeatUntilStable(() -> new MavenVisitor<ExecutionContext>(){
            private final @Nullable Scope scope;
            {
                this.scope = ExcludeDependency.this.scope == null ? null : Scope.fromName(ExcludeDependency.this.scope);
            }

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml xml = super.visitDocument(document, (Object)ctx);
                if (xml != document) {
                    xml = (Xml)new UpdateMavenModel().visitNonNull((Tree)xml, ctx);
                }
                return xml;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag()) {
                    ResolvedDependency dependency = this.findDependency(tag, this.scope);
                    if (!(dependency == null || StringUtils.matchesGlob((String)dependency.getGroupId(), (String)ExcludeDependency.this.groupId) && StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)ExcludeDependency.this.artifactId) || dependency.findDependency(ExcludeDependency.this.groupId, ExcludeDependency.this.artifactId) == null)) {
                        Optional maybeExclusions = tag.getChild("exclusions");
                        if (maybeExclusions.isPresent()) {
                            Xml.Tag exclusions = (Xml.Tag)maybeExclusions.get();
                            List individualExclusions = exclusions.getChildren("exclusion");
                            if (individualExclusions.stream().noneMatch(exclusion -> ExcludeDependency.this.groupId.equals(exclusion.getChildValue("groupId").orElse(null)) && ExcludeDependency.this.artifactId.equals(exclusion.getChildValue("artifactId").orElse(null)))) {
                                Xml.Tag newExclusions = (Xml.Tag)new AddToTagVisitor(exclusions, Xml.Tag.build((String)("<exclusion>\n<groupId>" + ExcludeDependency.this.groupId + "</groupId>\n<artifactId>" + ExcludeDependency.this.artifactId + "</artifactId>\n</exclusion>"))).visitNonNull((Tree)exclusions, (Object)ctx, this.getCursor());
                                tag = tag.withContent(ListUtils.map((List)tag.getContent(), t -> t == exclusions ? newExclusions : t));
                            }
                        } else {
                            tag = (Xml.Tag)new AddToTagVisitor(tag, Xml.Tag.build((String)("<exclusions>\n<exclusion>\n<groupId>" + ExcludeDependency.this.groupId + "</groupId>\n<artifactId>" + ExcludeDependency.this.artifactId + "</artifactId>\n</exclusion>\n</exclusions>"))).visitNonNull((Tree)tag, (Object)ctx, this.getCursor().getParentOrThrow());
                        }
                    }
                    return tag;
                }
                return super.visitTag(tag, (Object)ctx);
            }
        });
    }

    @Generated
    public ExcludeDependency(String groupId, String artifactId, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.scope = scope;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ExcludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", scope=" + this.getScope() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcludeDependency)) {
            return false;
        }
        ExcludeDependency other = (ExcludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ExcludeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

