/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class EnableDevelocityBuildCache
extends Recipe {
    private final String displayName = "Enable Develocity build cache";
    private final String description = "Add Develocity build cache configuration to any `.mvn/` Develocity configuration file that lack existing configuration.";
    @Option(displayName="Enable local build cache", description="Value for `//develocity/buildCache/local/enabled`.", example="true", required=false)
    private final @Nullable String localEnabled;
    @Option(displayName="Enable remote build cache", description="Value for `//develocity/buildCache/remote/enabled`.", example="true", required=false)
    private final @Nullable String remoteEnabled;
    @Option(displayName="Enable remote build cache store", description="Value for `//develocity/buildCache/remote/storeEnabled`.", example="#{isTrue(env['CI'])}", required=false)
    private final @Nullable String remoteStoreEnabled;

    public Validated<Object> validate(ExecutionContext ctx) {
        return super.validate(ctx).and(Validated.notBlank((String)"localEnabled", (String)this.localEnabled).or(Validated.notBlank((String)"remoteEnabled", (String)this.remoteEnabled)).or(Validated.notBlank((String)"remoteStoreEnabled", (String)this.remoteStoreEnabled)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".mvn/*.xml"), (TreeVisitor)new XmlVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Tag rootTag = document.getRoot();
                if ("develocity".equals(rootTag.getName()) && !rootTag.getChild("buildCache").isPresent()) {
                    Xml.Tag tag = Xml.Tag.build((String)this.buildCacheConfig());
                    rootTag = (Xml.Tag)this.maybeAutoFormat((Xml)rootTag, (Xml)rootTag.withContent(ListUtils.concat((List)rootTag.getChildren(), (Object)tag)), ctx);
                    return document.withRoot(rootTag);
                }
                return document;
            }

            private String buildCacheConfig() {
                StringBuilder sb = new StringBuilder("<buildCache>");
                if (!StringUtils.isBlank((String)EnableDevelocityBuildCache.this.localEnabled)) {
                    sb.append("<local>");
                    sb.append("<enabled>").append(EnableDevelocityBuildCache.this.localEnabled).append("</enabled>");
                    sb.append("</local>");
                }
                if (!StringUtils.isBlank((String)EnableDevelocityBuildCache.this.remoteEnabled) || !StringUtils.isBlank((String)EnableDevelocityBuildCache.this.remoteStoreEnabled)) {
                    sb.append("<remote>");
                    if (!StringUtils.isBlank((String)EnableDevelocityBuildCache.this.remoteEnabled)) {
                        sb.append("<enabled>").append(EnableDevelocityBuildCache.this.remoteEnabled).append("</enabled>");
                    }
                    if (!StringUtils.isBlank((String)EnableDevelocityBuildCache.this.remoteStoreEnabled)) {
                        sb.append("<storeEnabled>").append(EnableDevelocityBuildCache.this.remoteStoreEnabled).append("</storeEnabled>");
                    }
                    sb.append("</remote>");
                }
                sb.append("</buildCache>");
                return sb.toString();
            }
        });
    }

    @Generated
    public EnableDevelocityBuildCache(@Nullable String localEnabled, @Nullable String remoteEnabled, @Nullable String remoteStoreEnabled) {
        this.localEnabled = localEnabled;
        this.remoteEnabled = remoteEnabled;
        this.remoteStoreEnabled = remoteStoreEnabled;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public @Nullable String getLocalEnabled() {
        return this.localEnabled;
    }

    @Generated
    public @Nullable String getRemoteEnabled() {
        return this.remoteEnabled;
    }

    @Generated
    public @Nullable String getRemoteStoreEnabled() {
        return this.remoteStoreEnabled;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EnableDevelocityBuildCache(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", localEnabled=" + this.getLocalEnabled() + ", remoteEnabled=" + this.getRemoteEnabled() + ", remoteStoreEnabled=" + this.getRemoteStoreEnabled() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnableDevelocityBuildCache)) {
            return false;
        }
        EnableDevelocityBuildCache other = (EnableDevelocityBuildCache)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$localEnabled = this.getLocalEnabled();
        String other$localEnabled = other.getLocalEnabled();
        if (this$localEnabled == null ? other$localEnabled != null : !this$localEnabled.equals(other$localEnabled)) {
            return false;
        }
        String this$remoteEnabled = this.getRemoteEnabled();
        String other$remoteEnabled = other.getRemoteEnabled();
        if (this$remoteEnabled == null ? other$remoteEnabled != null : !this$remoteEnabled.equals(other$remoteEnabled)) {
            return false;
        }
        String this$remoteStoreEnabled = this.getRemoteStoreEnabled();
        String other$remoteStoreEnabled = other.getRemoteStoreEnabled();
        return !(this$remoteStoreEnabled == null ? other$remoteStoreEnabled != null : !this$remoteStoreEnabled.equals(other$remoteStoreEnabled));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof EnableDevelocityBuildCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $localEnabled = this.getLocalEnabled();
        result = result * 59 + ($localEnabled == null ? 43 : $localEnabled.hashCode());
        String $remoteEnabled = this.getRemoteEnabled();
        result = result * 59 + ($remoteEnabled == null ? 43 : $remoteEnabled.hashCode());
        String $remoteStoreEnabled = this.getRemoteStoreEnabled();
        result = result * 59 + ($remoteStoreEnabled == null ? 43 : $remoteStoreEnabled.hashCode());
        return result;
    }
}

