/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginExecutions
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="Executions", description="Plugin goal executions provided as raw XML. Supplying `null` will remove any existing executions.", example="<execution><phase>validate</phase><goals><goal>dryRun</goal></goals></execution>", required=false)
    @Language(value="xml")
    private final @Nullable String executions;
    private final String displayName = "Change Maven plugin executions";
    private final String description = "Apply the specified executions to a Maven plugin. Will not add the plugin if it does not already exist in the pom.";

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s`", this.groupId, this.artifactId);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional<Xml.Tag> maybePlugin;
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (PLUGINS_MATCHER.matches(this.getCursor()) && (maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && ChangePluginExecutions.this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && ChangePluginExecutions.this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny()).isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    plugins = ChangePluginExecutions.this.executions == null ? FilterTagChildrenVisitor.filterChildren((Xml.Tag)plugins, (Xml.Tag)plugin2, child -> !(child instanceof Xml.Tag) || !"executions".equals(((Xml.Tag)child).getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)plugins, (Xml.Tag)plugin2, (Xml.Tag)Xml.Tag.build((String)("<executions>\n" + ChangePluginExecutions.this.executions + "\n</executions>")), (Cursor)this.getCursor().getParentOrThrow());
                }
                return plugins;
            }
        };
    }

    @Generated
    public ChangePluginExecutions(String groupId, String artifactId, @Language(value="xml") @Nullable String executions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.executions = executions;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Language(value="xml")
    @Generated
    public @Nullable String getExecutions() {
        return this.executions;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginExecutions(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", executions=" + this.getExecutions() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginExecutions)) {
            return false;
        }
        ChangePluginExecutions other = (ChangePluginExecutions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$executions = this.getExecutions();
        String other$executions = other.getExecutions();
        if (this$executions == null ? other$executions != null : !this$executions.equals(other$executions)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePluginExecutions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : $executions.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

